/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.security.Principal;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.runtime.api.Framework;

public class ActivityStreamListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentCreated") || events.containsEventName("documentModified") || events.containsEventName("documentRemoved")) {
            for (Event event : events) {
                this.handleEvent(event);
            }
        }
    }

    private void handleEvent(Event event) throws ClientException {
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext && ("documentCreated".equals(event.getName()) || "documentRemoved".equals(event.getName()) || "documentModified".equals(event.getName()))) {
            DocumentEventContext docEventContext = (DocumentEventContext)eventContext;
            DocumentModel doc = docEventContext.getSourceDocument();
            if (doc instanceof ShallowDocumentModel || doc.hasFacet("HiddenInNavigation")) {
                return;
            }
            Activity activity = this.toActivity(docEventContext, event);
            ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
            activityStreamService.addActivity(activity);
        }
    }

    private Activity toActivity(DocumentEventContext docEventContext, Event event) {
        Principal principal = docEventContext.getPrincipal();
        DocumentModel doc = docEventContext.getSourceDocument();
        return new ActivityBuilder().actor(ActivityHelper.createUserActivityObject(principal)).displayActor(ActivityHelper.generateDisplayName(principal)).verb(event.getName()).object(ActivityHelper.createDocumentActivityObject(doc)).displayObject(ActivityHelper.getDocumentTitle(doc)).target(ActivityHelper.createDocumentActivityObject(doc.getRepositoryName(), doc.getParentRef().toString())).displayTarget(this.getDocumentTitle(docEventContext.getCoreSession(), doc.getParentRef())).build();
    }

    private String getDocumentTitle(CoreSession session, DocumentRef docRef) {
        try {
            DocumentModel doc = session.getDocument(docRef);
            return ActivityHelper.getDocumentTitle(doc);
        }
        catch (ClientException e) {
            return docRef.toString();
        }
    }
}

