/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageService;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.runtime.api.Framework;

public class MiniMessagePageProvider
extends AbstractActivityPageProvider<MiniMessage>
implements PageProvider<MiniMessage> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MiniMessagePageProvider.class);
    public static final String ACTOR_PROPERTY = "actor";
    public static final String RELATIONSHIP_KIND_PROPERTY = "relationshipKind";
    public static final String STREAM_TYPE_PROPERTY = "streamType";
    public static final String FOR_ACTOR_STREAM_TYPE = "forActor";
    public static final String FROM_ACTOR_STREAM_TYPE = "fromActor";
    protected List<MiniMessage> pageMiniMessages;

    public List<MiniMessage> getCurrentPage() {
        if (this.pageMiniMessages == null) {
            this.pageMiniMessages = new ArrayList<MiniMessage>();
            long pageSize = this.getMinMaxPageSize();
            MiniMessageService miniMessageService = (MiniMessageService)Framework.getLocalService(MiniMessageService.class);
            String streamType = this.getStreamType();
            if (FOR_ACTOR_STREAM_TYPE.equals(streamType)) {
                this.pageMiniMessages.addAll(miniMessageService.getMiniMessageFor(this.getActor(), this.getRelationshipKind(), this.getCurrentPageOffset(), pageSize));
            } else if (FROM_ACTOR_STREAM_TYPE.equals(streamType)) {
                this.pageMiniMessages.addAll(miniMessageService.getMiniMessageFrom(this.getActor(), this.getCurrentPageOffset(), pageSize));
            } else {
                log.error((Object)("Unknown stream type: " + streamType));
            }
            this.nextOffset = this.offset + (long)this.pageMiniMessages.size();
            this.setResultsCount(-2L);
        }
        return this.pageMiniMessages;
    }

    protected String getActor() {
        Map props = this.getProperties();
        String actor = (String)props.get(ACTOR_PROPERTY);
        if (actor == null) {
            throw new ClientRuntimeException("Cannot find actor property.");
        }
        return ActivityHelper.createUserActivityObject((String)actor);
    }

    protected String getStreamType() {
        Map props = this.getProperties();
        String streamType = (String)props.get(STREAM_TYPE_PROPERTY);
        if (streamType == null) {
            streamType = FOR_ACTOR_STREAM_TYPE;
        }
        return streamType;
    }

    protected RelationshipKind getRelationshipKind() {
        Map props = this.getProperties();
        String relationshipKind = (String)props.get(RELATIONSHIP_KIND_PROPERTY);
        if (relationshipKind == null) {
            throw new ClientRuntimeException("Cannot find relationshipKind property.");
        }
        return RelationshipKind.fromString((String)relationshipKind);
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageMiniMessages = null;
    }

    public void refresh() {
        super.refresh();
        this.pageMiniMessages = null;
    }
}

