/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageActivityStreamFilter;
import org.nuxeo.ecm.social.mini.message.MiniMessageService;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.runtime.api.Framework;

public class MiniMessageServiceImpl
implements MiniMessageService {
    @Override
    public MiniMessage addMiniMessage(Principal principal, String message, Date publishedDate) {
        return this.addMiniMessage(principal, message, publishedDate, null);
    }

    @Override
    public MiniMessage addMiniMessage(Principal principal, String message, Date publishedDate, String target) {
        Activity activity = new ActivityBuilder().actor(ActivityHelper.createUserActivityObject((Principal)principal)).displayActor(ActivityHelper.generateDisplayName((Principal)principal)).verb("minimessage").object(message).publishedDate(publishedDate).target(target).build();
        activity = this.getActivityStreamService().addActivity(activity);
        return MiniMessage.fromActivity(activity);
    }

    @Override
    public MiniMessage addMiniMessage(Principal principal, String message) {
        return this.addMiniMessage(principal, message, new Date());
    }

    @Override
    public void removeMiniMessage(MiniMessage miniMessage) {
        this.getActivityStreamService().removeActivities(Collections.singleton(miniMessage.getId()));
    }

    @Override
    public List<MiniMessage> getMiniMessageFor(String actorActivityObject, RelationshipKind relationshipKind, long offset, long limit) {
        return this.getMiniMessageFor(actorActivityObject, relationshipKind, null, offset, limit);
    }

    @Override
    public List<MiniMessage> getMiniMessageFor(String actorActivityObject, RelationshipKind relationshipKind, String targetActivityObject, long offset, long limit) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("actor", actorActivityObject);
        parameters.put("queryType", (Object)MiniMessageActivityStreamFilter.QueryType.MINI_MESSAGES_FOR_ACTOR);
        parameters.put("target", targetActivityObject);
        ActivitiesList activities = this.getActivityStreamService().query("MiniMessageActivityStreamFilter", parameters, offset, limit);
        ArrayList<MiniMessage> miniMessages = new ArrayList<MiniMessage>();
        for (Activity activity : activities) {
            miniMessages.add(MiniMessage.fromActivity(activity));
        }
        return miniMessages;
    }

    @Override
    public List<MiniMessage> getMiniMessageFrom(String actorActivityObject, long offset, long limit) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("actor", actorActivityObject);
        parameters.put("queryType", (Object)MiniMessageActivityStreamFilter.QueryType.MINI_MESSAGES_FROM_ACTOR);
        ActivitiesList activities = this.getActivityStreamService().query("MiniMessageActivityStreamFilter", parameters, offset, limit);
        ArrayList<MiniMessage> miniMessages = new ArrayList<MiniMessage>();
        for (Activity activity : activities) {
            miniMessages.add(MiniMessage.fromActivity(activity));
        }
        return miniMessages;
    }

    public ActivityStreamService getActivityStreamService() {
        return (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
    }
}

