/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo
 */

package org.nuxeo.ecm.social.relationship.service;

import java.util.HashMap;
import java.util.Map;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.social.relationship.RelationshipKind;

/**
 * User Relationship kind descriptor
 *
 * @author <a href="mailto:akervern@nuxeo.com">Arnaud Kervern</a>
 * @since 5.5
 */
@XObject("kind")
public class RelationshipKindDescriptor {

    @XNode("@name")
    protected String name;

    @XNode("@group")
    protected String group;

    @XNode("@enabled")
    protected boolean enabled = true;

    /**
     * Returns the ID of this {@code RelationshipKindDescriptor}.
     */
    public String getId() {
        return group + RelationshipKind.SEPARATOR + name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Object> getMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("group", group);
        return map;
    }

    @Override
    protected RelationshipKindDescriptor clone() {
        RelationshipKindDescriptor clone = new RelationshipKindDescriptor();
        clone.setGroup(group);
        clone.setName(name);
        clone.setEnabled(enabled);
        return clone;
    }
}
