/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "SocialWorkspaceActivityStreamFilter";
    public static final String REPOSITORY_NAME_PARAMETER = "repositoryName";
    public static final String SOCIAL_WORKSPACE_ID_PARAMETER = "socialWorkspaceId";
    public static final String SOCIAL_WORKSPACE_ACTIVITY_STREAM_NAME = "socialWorkspaceActivityStream";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return false;
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        String repositoryName = (String)((Object)parameters.get(REPOSITORY_NAME_PARAMETER));
        if (repositoryName == null) {
            throw new IllegalArgumentException("repositoryName is required");
        }
        String socialWorkspaceId = (String)((Object)parameters.get(SOCIAL_WORKSPACE_ID_PARAMETER));
        if (socialWorkspaceId == null) {
            throw new IllegalArgumentException("socialWorkspaceId is required");
        }
        ActivityStream socialWorkspaceActivityStream = activityStreamService.getActivityStream(SOCIAL_WORKSPACE_ACTIVITY_STREAM_NAME);
        List verbs = socialWorkspaceActivityStream.getVerbs();
        List relationshipKinds = socialWorkspaceActivityStream.getRelationshipKinds();
        String socialWorkspaceActivityObject = ActivityHelper.createDocumentActivityObject((String)repositoryName, (String)socialWorkspaceId);
        RelationshipService relationshipService = (RelationshipService)Framework.getLocalService(RelationshipService.class);
        ArrayList<String> actors = new ArrayList<String>();
        for (String relationshipKind : relationshipKinds) {
            actors.addAll(relationshipService.getTargetsOfKind(socialWorkspaceActivityObject, RelationshipKind.fromString((String)relationshipKind)));
        }
        actors.add(socialWorkspaceActivityObject);
        if (actors.isEmpty()) {
            return new ActivitiesListImpl();
        }
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        Query query = em.createQuery("select activity from Activity activity where activity.actor in (:actors) and activity.verb in (:verbs) and activity.target = :target order by activity.publishedDate desc");
        query.setParameter("actors", actors);
        query.setParameter("target", (Object)socialWorkspaceActivityObject);
        query.setParameter("verbs", (Object)verbs);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }
}

