/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webengine.fm.extensions;

import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.models.InfoPool;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.webengine.fm.extensions.Utils;

public class NXThemesFragmentDirective
implements TemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(NXThemesFragmentDirective.class);
    final String templateEngine = "freemarker";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("Didn't expect a body");
        }
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx == null) {
            throw new IllegalStateException("Not In a Web Context");
        }
        env.setVariable("nxthemesInfo", BeansWrapper.getDefaultInstance().wrap((Object)InfoPool.getInfoMap()));
        Map<String, String> attributes = Utils.getTemplateDirectiveParameters(params);
        URL elementUrl = new URL(String.format("nxtheme://element/%s/%s/%s/%s", attributes.get("engine"), attributes.get("mode"), "freemarker", attributes.get("uid")));
        String rendered = "";
        try {
            rendered = ThemeManager.renderElement((URL)elementUrl);
        }
        catch (ThemeException e) {
            log.error((Object)("Element rendering failed: " + e.getMessage()));
            return;
        }
        StringReader sr = new StringReader(rendered);
        BufferedReader reader = new BufferedReader(sr);
        Template tpl = new Template(elementUrl.toString(), (Reader)reader, env.getConfiguration(), env.getTemplate().getEncoding());
        try {
            env.include(tpl);
        }
        catch (Exception e) {
            log.error((Object)("Rendering of Freemarker template failed: \n" + rendered), (Throwable)e);
        }
        finally {
            reader.close();
            sr.close();
        }
    }
}

