/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.NuxeoGroupImpl;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="UserManager")
@Produces(value={"text/html;charset=UTF-8"})
public class UserService
extends DefaultObject {
    @GET
    public Object getIndex(@QueryParam(value="query") String query, @QueryParam(value="group") String group) throws Exception {
        if (query != null && !query.isEmpty()) {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            if (group != null) {
                DocumentModelList results = userManager.searchGroups(query);
                return this.getView("index").arg("groups", (Object)results);
            }
            List results = userManager.searchPrincipals(query);
            return this.getView("index").arg("users", (Object)results);
        }
        return this.getView("index");
    }

    @Path(value="user/{user}")
    public Object searchUsers(@PathParam(value="user") String user) throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipalImpl principal = (NuxeoPrincipalImpl)userManager.getPrincipal(user);
        if (principal == null) {
            throw new WebResourceNotFoundException("User not found: " + user);
        }
        return this.newObject("User", new Object[]{principal});
    }

    @Path(value="group/{group}")
    public Object searchGroups(@PathParam(value="group") String group) throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoGroup principal = userManager.getGroup(group);
        if (principal == null) {
            throw new WebResourceNotFoundException("Group not found: " + group);
        }
        return this.newObject("Group", new Object[]{principal});
    }

    @POST
    @Path(value="user")
    public Response postUser() throws Exception {
        HttpServletRequest req = this.ctx.getRequest();
        String username = req.getParameter("username");
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (username != null && !username.isEmpty()) {
            NuxeoPrincipalImpl user = (NuxeoPrincipalImpl)userManager.getPrincipal(username);
            if (user != null) {
                user.setFirstName(req.getParameter("firstName"));
                user.setLastName(req.getParameter("lastName"));
                user.setPassword(req.getParameter("password"));
                user.setEmail(req.getParameter("email"));
                String[] selectedGroups = req.getParameterValues("groups");
                List<String> listGroups = Arrays.asList(selectedGroups);
                user.setGroups(listGroups);
                userManager.updatePrincipal((NuxeoPrincipal)user);
            } else {
                user = new NuxeoPrincipalImpl(req.getParameter("username"));
                user.setFirstName(req.getParameter("firstName"));
                user.setLastName(req.getParameter("lastName"));
                user.setPassword(req.getParameter("password"));
                user.setEmail(req.getParameter("email"));
                String[] selectedGroups = req.getParameterValues("groups");
                List<String> listGroups = Arrays.asList(selectedGroups);
                user.setGroups(listGroups);
                userManager.createPrincipal((NuxeoPrincipal)user);
            }
            return this.redirect(this.getPath() + "/user/" + user.getName());
        }
        return null;
    }

    @POST
    @Path(value="group")
    public Response postGroup() throws Exception {
        String groupName = this.ctx.getRequest().getParameter("groupName");
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (groupName != null && !groupName.equals("")) {
            NuxeoGroupImpl group = new NuxeoGroupImpl(groupName);
            userManager.createGroup((NuxeoGroup)group);
            return this.redirect(this.getPath() + "/group/" + group.getName());
        }
        return null;
    }

    public List<NuxeoGroup> getGroups() throws Exception {
        return ((UserManager)Framework.getService(UserManager.class)).getAvailableGroups();
    }

    public List<NuxeoPrincipal> getUsers() throws Exception {
        return ((UserManager)Framework.getService(UserManager.class)).getAvailablePrincipals();
    }
}

