/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest.security;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.rest.security.Permission;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.View;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.ecm.webengine.util.ACLUtils;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebAdapter(name="permissions", type="PermissionService", targetType="Document", targetFacets={"Folderish"})
public class PermissionService
extends DefaultAdapter {
    @GET
    public Object doGet() {
        return new View(this.getTarget(), "permissions").resolve();
    }

    @POST
    @Path(value="add")
    public Response postPermission() {
        try {
            NuxeoGroup group;
            HttpServletRequest req = this.ctx.getRequest();
            String action = req.getParameter("action");
            String permission = req.getParameter("permission");
            String username = req.getParameter("user");
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            NuxeoPrincipal user = userManager.getPrincipal(username);
            if (user == null && (group = userManager.getGroup(username)) == null) {
                return Response.status((int)500).build();
            }
            ACPImpl acp = new ACPImpl();
            ACLImpl acl = new ACLImpl("local");
            acp.addACL((ACL)acl);
            boolean granted = "grant".equals(action);
            ACE ace = new ACE(username, permission, granted);
            acl.add((Object)ace);
            CoreSession session = this.ctx.getCoreSession();
            Resource target = this.getTarget();
            session.setACP(((DocumentModel)target.getAdapter(DocumentModel.class)).getRef(), (ACP)acp, false);
            session.save();
            return this.redirect(target.getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    @Path(value="delete")
    public Response postDeletePermission() {
        return this.deletePermission();
    }

    @GET
    @Path(value="delete")
    public Response deletePermission() {
        try {
            HttpServletRequest req = this.ctx.getRequest();
            String permission = req.getParameter("permission");
            String username = req.getParameter("user");
            CoreSession session = this.ctx.getCoreSession();
            Resource target = this.getTarget();
            ACLUtils.removePermission((CoreSession)session, (DocumentRef)((DocumentModel)target.getAdapter(DocumentModel.class)).getRef(), (String)username, (String)permission);
            session.save();
            return this.redirect(target.getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public List<Permission> getPermissions() {
        try {
            ACP acp = this.ctx.getCoreSession().getACP(((DocumentModel)this.getTarget().getAdapter(DocumentModel.class)).getRef());
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (ACL acl : acp.getACLs()) {
                for (ACE ace : acl.getACEs()) {
                    permissions.add(new Permission(ace.getUsername(), ace.getPermission(), ace.isGranted()));
                }
            }
            return permissions;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get ACLs", (Throwable)e);
        }
    }
}

