/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.workflow.services.CommentsModerationService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="comments", type="CommentService", targetType="Document", targetFacets={"Commentable"})
public class CommentService
extends DefaultAdapter {
    @POST
    public Response doPost(@FormParam(value="text") String cText) {
        if (cText == null) {
            throw new IllegalParameterException("Expecting a 'text' parameter");
        }
        DocumentObject dobj = (DocumentObject)this.getTarget();
        CoreSession session = dobj.getCoreSession();
        DocumentModel pageDoc = dobj.getDocument();
        try {
            DocumentModel comment = session.createDocumentModel("Comment");
            comment.setPropertyValue("comment:author", (Serializable)((Object)session.getPrincipal().getName()));
            comment.setPropertyValue("comment:text", (Serializable)((Object)cText));
            comment.setPropertyValue("comment:creationDate", (Serializable)new Date());
            comment = this.createCommentDocument(session, pageDoc, comment);
            session.save();
            this.publishComment(session, pageDoc, comment);
            return this.redirect(this.getTarget().getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="reject")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Response reject() {
        try {
            DocumentObject dobj = (DocumentObject)this.getTarget();
            CoreSession session = dobj.getCoreSession();
            DocumentModel pageDoc = dobj.getDocument();
            FormData form = this.ctx.getForm();
            String commentId = form.getString("property");
            DocumentModel comment = session.getDocument((DocumentRef)new IdRef(commentId));
            this.rejectComment(session, pageDoc, comment);
            return this.redirect(dobj.getPath());
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to reject comment", (Throwable)e);
        }
    }

    @GET
    @Path(value="approve")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Response approve() {
        try {
            DocumentObject dobj = (DocumentObject)this.getTarget();
            CoreSession session = dobj.getCoreSession();
            DocumentModel pageDoc = dobj.getDocument();
            FormData form = this.ctx.getForm();
            String commentId = form.getString("property");
            DocumentModel comment = session.getDocument((DocumentRef)new IdRef(commentId));
            this.approveComent(session, pageDoc, comment);
            return this.redirect(dobj.getPath());
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to approve comment", (Throwable)e);
        }
    }

    @GET
    @Path(value="delete")
    public Response remove() {
        try {
            return this.deleteComment();
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to delete comment", (Throwable)e);
        }
    }

    @DELETE
    public Response deleteComment() throws Exception {
        DocumentObject dobj = (DocumentObject)this.getTarget();
        CoreSession session = dobj.getCoreSession();
        FormData form = this.ctx.getForm();
        String docId = form.getString("property");
        DocumentModel comment = session.getDocument((DocumentRef)new IdRef(docId));
        this.deleteComment(dobj.getDocument(), comment);
        return this.redirect(dobj.getPath());
    }

    public static CommentManager getCommentManager() throws Exception {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager == null) {
            throw new WebException("Unable to get commentManager");
        }
        return commentManager;
    }

    public static CommentsModerationService getCommentsModerationService() throws Exception {
        CommentsModerationService commentsModerationService = (CommentsModerationService)Framework.getService(CommentsModerationService.class);
        if (commentsModerationService == null) {
            throw new WebException("Unable to get CommentsModerationService ");
        }
        return commentsModerationService;
    }

    protected DocumentModel createCommentDocument(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        return CommentService.getCommentManager().createComment(target, comment);
    }

    protected void publishComment(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        CommentService.getCommentsModerationService().publishComment(session, comment);
    }

    protected void deleteComment(DocumentModel target, DocumentModel comment) throws Exception {
        CommentService.getCommentManager().deleteComment(target, comment);
    }

    protected void rejectComment(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        CommentService.getCommentsModerationService().rejectComment(session, target, comment.getId());
        CommentService.getCommentManager().deleteComment(target, comment);
    }

    protected void approveComent(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        CommentService.getCommentsModerationService().approveComent(session, target, comment.getId());
    }
}

