/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.forms.validation.Form;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.ui.wizard.WizardPage;
import org.nuxeo.ecm.webengine.ui.wizard.WizardSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Wizard
extends DefaultObject {
    private static final Log log = LogFactory.getLog(Wizard.class);
    public static final String[] EMPTY = new String[0];
    protected WizardSession session;
    protected WizardPage page;
    protected ValidationException error;
    protected Map<String, String[]> initialFields;

    protected abstract WizardPage[] createPages();

    protected Map<String, String[]> createInitialFields() {
        return null;
    }

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpSession httpSession = this.ctx.getRequest().getSession(true);
        String key = this.createSessionId();
        this.session = (WizardSession)httpSession.getAttribute(key);
        if (this.session == null) {
            this.session = new WizardSession(key, this.createPages());
            httpSession.setAttribute(key, (Object)this.session);
            this.initialFields = this.createInitialFields();
            if (this.initialFields == null) {
                this.initialFields = new HashMap<String, String[]>();
            }
        }
        this.page = this.session.getPage();
    }

    protected void destroySession() {
        HttpSession httpSession = this.ctx.getRequest().getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(this.session.getId());
        }
    }

    protected String createSessionId() {
        return "wizard:" + ((Object)((Object)this)).getClass();
    }

    public WizardSession getSession() {
        return this.session;
    }

    public WizardPage getPage() {
        return this.page;
    }

    public boolean isNextEnabled() {
        return this.page.isNextEnabled();
    }

    public boolean isBackEnabled() {
        return this.page.isBackEnabled();
    }

    public boolean isOkEnabled() {
        return this.page.isOkEnabled();
    }

    public boolean isCancelEnabled() {
        return this.page.isCancelEnabled();
    }

    public ValidationException getError() {
        return this.error;
    }

    public Map<String, String[]> getFormFields() {
        Form form = this.session.getPage().getForm();
        if (form != null) {
            return form.fields();
        }
        return this.initialFields == null ? Collections.EMPTY_MAP : this.initialFields;
    }

    public String getField(String key) {
        String[] v = this.getFormFields().get(key);
        return v != null && v.length > 0 ? v[0] : null;
    }

    public String[] getFields(String key) {
        String[] fields = this.getFormFields().get(key);
        return fields == null ? EMPTY : fields;
    }

    public Collection<String> getInvalidFields() {
        if (this.error != null) {
            return this.error.getInvalidFields();
        }
        return null;
    }

    public Collection<String> getRequireddFields() {
        if (this.error != null) {
            return this.error.getRequiredFields();
        }
        return null;
    }

    public boolean hasErrors() {
        return this.error != null;
    }

    public boolean hasErrors(String key) {
        if (this.error != null) {
            return this.error.hasErrors(key);
        }
        return false;
    }

    protected Object redirectOnOk() {
        return this.redirect(this.getPrevious().getPath());
    }

    protected Object redirectOnCancel() {
        return this.redirect(this.getPrevious().getPath());
    }

    public <T extends Form> T getForm(Class<T> formType) {
        return this.session.getForm(formType);
    }

    protected abstract void performOk() throws ValidationException;

    protected void performCancel() {
        this.destroySession();
    }

    protected Object handleValidationError(ValidationException e) {
        this.session.setError(e);
        return this.redirect(this.getPath());
    }

    protected Object handleError(Throwable e) {
        log.error((Object)("Processing failed in wizard page: " + this.session.getPage().getId()), e);
        this.session.setError(new ValidationException("Processing failed: " + e.getMessage(), e));
        return this.redirect(this.getPath());
    }

    public <T extends Form> T validate(WizardPage page) throws ValidationException {
        try {
            Form form = this.ctx.getForm().validate(page.getFormType());
            page.setForm(form);
            return (T)form;
        }
        catch (ValidationException e) {
            page.setForm(e.getForm());
            throw e;
        }
    }

    @POST
    @Path(value="next")
    public Object handleNext() {
        String pageId = null;
        try {
            pageId = this.page.getNextPage(this, this.validate(this.page));
            if (pageId == "") {
                pageId = this.session.getPageAt(this.page.getIndex() + 1);
            }
            if (pageId == null) {
                this.performOk();
                this.destroySession();
                return this.redirectOnOk();
            }
            this.session.pushPage(pageId);
            return this.redirect(this.getPath());
        }
        catch (ValidationException e) {
            return this.handleValidationError(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    @POST
    @Path(value="back")
    public Object handleBack() {
        this.session.popPage();
        return this.redirect(this.getPath());
    }

    @POST
    @Path(value="cancel")
    public Object handleCancel() {
        this.performCancel();
        return this.redirectOnCancel();
    }

    @POST
    @Path(value="ok")
    public Object handleOk() {
        try {
            this.validate(this.page);
            this.performOk();
            this.destroySession();
            return this.redirectOnOk();
        }
        catch (ValidationException e) {
            return this.handleValidationError(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    @GET
    public Object doGet() {
        this.error = this.session.removeError();
        return this.getView(this.page.getId());
    }
}

