/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.wizard;

import java.io.Serializable;
import org.nuxeo.ecm.webengine.forms.validation.Form;
import org.nuxeo.ecm.webengine.ui.wizard.Wizard;

public class WizardPage
implements Serializable {
    private static final long serialVersionUID = -1156377274574342525L;
    public static final String NEXT_PAGE = "";
    public static final int NEXT = 1;
    public static final int BACK = 2;
    public static final int CANCEL = 4;
    public static final int OK = 8;
    public static final int INITIAL = 5;
    public static final int MIDDLE = 7;
    public static final int LAST = 14;
    protected int index;
    protected final String nextPageId;
    protected final Class<? extends Form> formType;
    protected final String id;
    protected final int style;
    protected Form form;
    protected WizardPage prev;

    public WizardPage(String id, Class<? extends Form> formType) {
        this(id, formType, 7);
    }

    public WizardPage(String id, Class<? extends Form> formType, int style) {
        this(id, formType, NEXT_PAGE, style);
    }

    public WizardPage(String id, Class<? extends Form> formType, String nextPageId) {
        this(id, formType, nextPageId, 7);
    }

    public WizardPage(String id, Class<? extends Form> formType, String nextPageId, int style) {
        this.id = id;
        this.formType = formType;
        this.nextPageId = nextPageId;
        this.style = style;
        this.prev = null;
    }

    public Class<? extends Form> getFormType() {
        return this.formType;
    }

    public String getId() {
        return this.id;
    }

    public boolean isNextEnabled() {
        return (this.style & 1) != 0;
    }

    public boolean isBackEnabled() {
        return (this.style & 2) != 0;
    }

    public boolean isOkEnabled() {
        return (this.style & 8) != 0;
    }

    public boolean isCancelEnabled() {
        return (this.style & 4) != 0;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public Form getForm() {
        return this.form;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public <T extends Form> String getNextPage(Wizard wizard, T form) {
        return this.nextPageId;
    }
}

