/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.blogs.fragments;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.blogs.models.BlogPostListModel;
import org.nuxeo.webengine.blogs.models.BlogPostModel;
import org.nuxeo.webengine.blogs.models.BlogSiteArchiveDayModel;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class RecentBlogPostsFragment
extends AbstractFragment {
    public static final int noForBlogSite = 15;
    public static final int noForBlogPost = 5;
    private static String[] weekDays;

    public Model getModel() throws ModelException {
        BlogPostListModel model = new BlogPostListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            BlogPostModel blogPostModel = null;
            BlogSiteArchiveDayModel dayModel = null;
            GregorianCalendar creationDate = null;
            String title = null;
            String path = null;
            String description = null;
            String content = null;
            String author = null;
            String day = null;
            SimpleDateFormat simpleMonthFormat = new SimpleDateFormat("dd MMMM yyyy", WebEngine.getActiveContext().getLocale());
            try {
                DocumentModel blogSite = SiteUtils.getFirstWebSiteParent((CoreSession)session, (DocumentModel)documentModel);
                DocumentModelList blogPosts = SiteQueriesColection.queryLastModifiedPages((CoreSession)session, (String)blogSite.getPathAsString(), (String)"BlogPost", (int)("BlogPost".equals(documentModel.getType()) ? 5 : 15));
                for (DocumentModel blogPost : blogPosts) {
                    title = SiteUtils.getString((DocumentModel)blogPost, (String)"dc:title");
                    path = SiteUtils.getPagePath((DocumentModel)blogSite, (DocumentModel)blogPost);
                    description = SiteUtils.getString((DocumentModel)blogPost, (String)"dc:description");
                    content = SiteUtils.getFistNWordsFromString((String)SiteUtils.getString((DocumentModel)blogPost, (String)"webp:content"), (int)Integer.MAX_VALUE);
                    author = SiteUtils.getString((DocumentModel)blogPost, (String)"dc:creator");
                    creationDate = SiteUtils.getGregorianCalendar((DocumentModel)blogPost, (String)"dc:created");
                    day = RecentBlogPostsFragment.getWeekDay(creationDate.get(7));
                    dayModel = this.getYearModel((Model)model, day);
                    if (dayModel == null) {
                        dayModel = new BlogSiteArchiveDayModel(day, simpleMonthFormat.format(creationDate.getTime()), 0);
                        model.addItem((Model)dayModel);
                    }
                    dayModel.increaseCount();
                    blogPostModel = new BlogPostModel(title, path, description, content, author);
                    dayModel.addItem((Model)blogPostModel);
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }

    private static String getWeekDay(int day) {
        if (weekDays == null) {
            DateFormatSymbols dfs = new DateFormatSymbols(WebEngine.getActiveContext().getLocale());
            weekDays = dfs.getWeekdays();
        }
        return weekDays[day];
    }

    private BlogSiteArchiveDayModel getYearModel(Model model, String day) {
        BlogSiteArchiveDayModel dayModel = null;
        for (Model item : model.getItems()) {
            String itemDay;
            if (!(item instanceof BlogSiteArchiveDayModel) || !day.equals(itemDay = ((BlogSiteArchiveDayModel)item).getDay())) continue;
            dayModel = (BlogSiteArchiveDayModel)item;
            break;
        }
        return dayModel;
    }
}

