/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.blogs.fragments;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.blogs.models.BlogSiteArchiveListModel;
import org.nuxeo.webengine.blogs.models.BlogSiteArchiveMonthModel;
import org.nuxeo.webengine.blogs.models.BlogSiteArchiveYearModel;
import org.nuxeo.webengine.blogs.utils.BlogQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class BlogSiteArchiveFragment
extends AbstractFragment {
    public static final String path = "search";

    public Model getModel() throws ModelException {
        BlogSiteArchiveListModel model = new BlogSiteArchiveListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            BlogSiteArchiveYearModel archiveYearModel = null;
            BlogSiteArchiveMonthModel archiveMonthModel = null;
            GregorianCalendar creationDate = null;
            String[] dateDetails = null;
            SimpleDateFormat simpleMonthFormat = new SimpleDateFormat("MMMM MM yyyy", WebEngine.getActiveContext().getLocale());
            try {
                DocumentModel blogSite = SiteUtils.getFirstWebSiteParent((CoreSession)session, (DocumentModel)documentModel);
                DocumentModelList blogPosts = BlogQueriesColection.getAllBlogPosts((CoreSession)session, (String)blogSite.getPathAsString());
                for (DocumentModel blogPost : blogPosts) {
                    creationDate = SiteUtils.getGregorianCalendar((DocumentModel)blogPost, (String)"dc:created");
                    if (creationDate == null) continue;
                    dateDetails = simpleMonthFormat.format(creationDate.getTime()).split(" ");
                    archiveYearModel = this.getYearModel((Model)model, dateDetails[2]);
                    if (archiveYearModel == null) {
                        archiveYearModel = new BlogSiteArchiveYearModel(dateDetails[2], path, 0);
                        model.addItem((Model)archiveYearModel);
                    }
                    archiveYearModel.increaseCount();
                    archiveMonthModel = this.getMonthModel((Model)archiveYearModel, dateDetails[1]);
                    if (archiveMonthModel == null) {
                        archiveMonthModel = new BlogSiteArchiveMonthModel(dateDetails[0], dateDetails[1], path, 0);
                        archiveYearModel.addItem((Model)archiveMonthModel);
                    }
                    archiveMonthModel.increaseCount();
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }

    private BlogSiteArchiveYearModel getYearModel(Model model, String year) {
        BlogSiteArchiveYearModel yearModel = null;
        for (Model item : model.getItems()) {
            String itemYear;
            if (!(item instanceof BlogSiteArchiveYearModel) || !year.equals(itemYear = ((BlogSiteArchiveYearModel)item).getYearLong())) continue;
            yearModel = (BlogSiteArchiveYearModel)item;
            break;
        }
        return yearModel;
    }

    private BlogSiteArchiveMonthModel getMonthModel(Model model, String month) {
        BlogSiteArchiveMonthModel monthModel = null;
        for (Model item : model.getItems()) {
            String itemMonth;
            if (!(item instanceof BlogSiteArchiveMonthModel) || !month.equals(itemMonth = ((BlogSiteArchiveMonthModel)item).getMonthShort())) continue;
            monthModel = (BlogSiteArchiveMonthModel)item;
            break;
        }
        return monthModel;
    }
}

