/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.gwt.codeserver;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.webengine.gwt.codeserver.CodeServerConfig;

public class CodeServerComponent
extends DefaultComponent {
    final Map<String, CodeServerConfig> servers = new HashMap<String, CodeServerConfig>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof CodeServerConfig) {
            CodeServerConfig install = (CodeServerConfig)contribution;
            this.servers.put(install.module, install);
        }
    }

    public void applicationStarted(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 2) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                CodeServerComponent.this.shutdown();
            }
        });
        this.startup();
    }

    protected void startup() {
        new Runner(){

            @Override
            void doRun(CodeServerConfig server) throws Exception {
                server.startup();
            }
        }.run();
    }

    protected void shutdown() {
        new Runner(){

            @Override
            void doRun(CodeServerConfig server) throws Exception {
                server.shutdown();
            }
        }.run();
    }

    abstract class Runner {
        Runner() {
        }

        void run() {
            NuxeoException errors = new NuxeoException("Cannot shudown gwt code servers");
            for (CodeServerConfig server : CodeServerComponent.this.servers.values()) {
                try {
                    this.doRun(server);
                }
                catch (Exception cause) {
                    errors.addSuppressed((Throwable)cause);
                }
            }
            if (errors.getSuppressed().length > 0) {
                throw errors;
            }
        }

        abstract void doRun(CodeServerConfig var1) throws Exception;
    }
}

