/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.gwt.codeserver;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.webengine.gwt.codeserver.CodeServerClasspath;
import org.nuxeo.webengine.gwt.codeserver.CodeServerLauncher;
import org.nuxeo.webengine.gwt.codeserver.CodeServerLoader;
import org.nuxeo.webengine.gwt.codeserver.CodeServerOption;

@XObject(value="codeserver")
public class CodeServerConfig {
    @XNode(value="@module")
    String module;
    @XNode(value="classpath")
    CodeServerClasspath classpath;
    @XNodeList(value="option", type=ArrayList.class, componentType=CodeServerOption.class)
    List<CodeServerOption> options = new ArrayList<CodeServerOption>();
    CodeServerLauncher launcher;
    private CodeServerLoader loader;

    String[] toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (CodeServerOption each : this.options) {
            each.toArgs(args);
        }
        args.add(this.module);
        return args.toArray(new String[args.size()]);
    }

    void startup() throws Exception {
        this.loader = new CodeServerLoader(this.classpath.entries);
        this.launcher = this.loader.load();
        this.launcher.startup(this.toArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws Exception {
        try {
            if (this.launcher != null) {
                this.launcher.shutdown();
            }
        }
        finally {
            this.launcher = null;
            try {
                if (this.loader != null) {
                    this.loader.close();
                }
            }
            finally {
                this.loader = null;
            }
        }
    }
}

