/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt.dev;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.dev.NuxeoApp;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.webengine.gwt.dev.RedirectService;

public class NuxeoLauncher
extends NuxeoAuthenticationFilter {
    private static final long serialVersionUID = 1L;
    protected static NuxeoApp app;
    protected static RedirectService redirect;

    protected void initializeGraph(NuxeoApp app) {
    }

    protected void buildDone(NuxeoApp app) {
    }

    protected void aboutToStartFramework(NuxeoApp app) {
    }

    protected void frameworkStarted(NuxeoApp app) {
    }

    protected URL getConfiguration() {
        return null;
    }

    protected boolean useCache() {
        return true;
    }

    public synchronized void init(FilterConfig config) throws ServletException {
        if (app != null) {
            return;
        }
        System.setProperty("nuxeo.gwt_dev_mode", "true");
        app = this.createApplication(config);
        Runtime.getRuntime().addShutdownHook(new Thread("Nuxeo Server Shutdown"){

            public void run() {
                try {
                    if (app != null) {
                        app.shutdown();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        super.init(config);
    }

    protected NuxeoApp createApplication(FilterConfig config) throws ServletException {
        String profile;
        URL cfg = this.getConfiguration();
        String homeParam = config.getInitParameter("home");
        String hostParam = config.getInitParameter("host");
        String portParam = config.getInitParameter("port");
        String profileParam = config.getInitParameter("profile");
        String updatePolicy = config.getInitParameter("updatePolicy");
        String offline = config.getInitParameter("offline");
        String redirectPrefix = config.getInitParameter("redirectPrefix");
        String redirectTrace = config.getInitParameter("redirectTrace");
        String redirectTraceContent = config.getInitParameter("redirectTraceContent");
        File home = null;
        String host = hostParam == null ? "localhost" : null;
        int port = portParam == null ? 8081 : Integer.parseInt(portParam);
        String string = profile = profileParam == null ? "core-5.3.1" : profileParam;
        if (homeParam == null) {
            String userDir = System.getProperty("user.home");
            String sep = userDir.endsWith("/") ? "" : "/";
            home = new File(userDir + sep + ".nxserver-gwt");
        } else {
            homeParam = StringUtils.expandVars((String)homeParam, (Map)System.getProperties());
            home = new File(homeParam);
        }
        redirect = new RedirectService(host, port);
        if (redirectPrefix != null) {
            redirect.setRedirectPrefix(redirectPrefix);
        }
        if (redirectTrace != null && Boolean.parseBoolean(redirectTrace)) {
            redirect.setTrace(true);
        }
        if (redirectTraceContent != null && Boolean.parseBoolean(redirectTraceContent)) {
            redirect.setTrace(true);
            redirect.setTraceContent(true);
        }
        System.out.println("+---------------------------------------------------------");
        System.out.println("| Nuxeo Server Profile: " + (profile == null ? "custom" : profile));
        System.out.println("| Home Directory: " + home);
        System.out.println("| HTTP server at: " + host + ":" + port);
        System.out.println("| Use cache: " + this.useCache() + "; Snapshot update policy: " + updatePolicy + "; offline: " + offline);
        System.out.println("+---------------------------------------------------------\n");
        NuxeoApp.setHttpServerAddress((String)host, (int)port);
        try {
            MyNuxeoApp app = new MyNuxeoApp(home);
            if (updatePolicy != null) {
                app.setUpdatePolicy(updatePolicy);
            }
            if (offline != null) {
                app.setOffline(Boolean.parseBoolean(offline));
            }
            if (cfg == null) {
                app.build(profile, this.useCache());
            } else {
                app.build(cfg, this.useCache());
            }
            app.start();
            return app;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getRequestURI().startsWith(redirect.getRedirectPrefix())) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            redirect.redirect(httpRequest, httpResponse);
            return;
        }
        super.doFilter(request, response, chain);
    }

    public class MyNuxeoApp
    extends NuxeoApp {
        public MyNuxeoApp(File home) throws Exception {
            super(home);
        }

        public MyNuxeoApp(File home, ClassLoader cl) throws Exception {
            super(home, cl);
        }

        protected void initializeGraph() throws Exception {
            super.initializeGraph();
            NuxeoLauncher.this.initializeGraph(this);
        }

        protected void aboutToStartFramework() throws Exception {
            super.aboutToStartFramework();
            NuxeoLauncher.this.aboutToStartFramework(this);
        }

        protected void buildDone() {
            super.buildDone();
            NuxeoLauncher.this.buildDone(this);
        }

        protected void frameworkStarted() throws Exception {
            super.frameworkStarted();
            NuxeoLauncher.this.frameworkStarted(this);
        }
    }
}

