/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt.dev;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.gwt.dev.Debug;

public class RedirectService
extends HttpServlet
implements Debug {
    private static final long serialVersionUID = 1L;
    protected static Pattern HTTP_RESP = Pattern.compile("HTTP/1\\..\\s+([0-9]+)\\s+(.*)");
    protected String redirectPrefix = "/redirect";
    protected String redirectHost = "localhost";
    protected int redirectPort = 8081;
    protected String redirectPattern = "/redirect/(.*)";
    protected String redirectReplacement = "/$1";
    protected boolean trace = false;
    protected boolean traceContent = false;

    public RedirectService(String host, int port) {
        this.redirectHost = host;
        this.redirectPort = port;
        System.out.println("----------------------------------------------------------");
        System.out.println("Redirect Service Enabled: ");
        System.out.println("redirect.prefix: " + this.redirectPrefix);
        System.out.println("redirect.host: " + this.redirectHost);
        System.out.println("redirect.port: " + this.redirectPort);
        System.out.println("redirect.pattern: " + this.redirectPattern);
        System.out.println("redirect.replacement: " + this.redirectReplacement);
        System.out.println("redirect.trace: " + this.trace);
        System.out.println("----------------------------------------------------------");
    }

    public String getRedirectPrefix() {
        return this.redirectPrefix;
    }

    public void setRedirectPrefix(String redirectPrefix) {
        this.redirectPrefix = redirectPrefix;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setTraceContent(boolean traceContent) {
        this.traceContent = traceContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redirect(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuilder buf = new StringBuilder();
        String urlPath = req.getRequestURI();
        urlPath = this.redirectPrefix.equals(urlPath) ? "/" : urlPath.replaceAll(this.redirectPattern, this.redirectReplacement);
        buf.append(req.getMethod()).append(" ").append(urlPath).append(" HTTP/1.0\r\n");
        Enumeration keys = req.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Enumeration vals = req.getHeaders(key);
            while (vals.hasMoreElements()) {
                if (!"connection".equalsIgnoreCase(key)) {
                    buf.append(key).append(": ").append((String)vals.nextElement()).append("\r\n");
                    continue;
                }
                vals.nextElement();
            }
        }
        buf.append("\r\n");
        InputStream rin = null;
        OutputStream rout = null;
        InputStream in = null;
        try {
            Socket socket = new Socket(this.redirectHost, this.redirectPort);
            rout = socket.getOutputStream();
            rout.write(buf.toString().getBytes());
            in = req.getInputStream();
            if (this.trace) {
                RedirectService.traceln("========== HTTP REQUEST ===========");
                RedirectService.traceln(buf.toString());
                RedirectService.traceln("");
                this.copyDebug(in, rout);
                RedirectService.traceln("===================================");
            } else {
                this.copy(in, rout);
            }
            rout.flush();
            rin = new BufferedInputStream(socket.getInputStream());
            if (this.trace) {
                RedirectService.traceln("========= HTTP RESPONSE ===========");
            }
            this.transferResponse(rin, resp);
            if (this.trace) {
                RedirectService.traceln("===================================");
            }
        }
        finally {
            if (rout != null) {
                rout.close();
            }
            if (rin != null) {
                rin.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public void copyDebug(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            if (!this.traceContent) continue;
            RedirectService.trace(new String(buffer, 0, read));
        }
        RedirectService.traceln("");
    }

    public int getStatusCode(String line) {
        Matcher matcher = HTTP_RESP.matcher(line.trim());
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferResponse(InputStream in, HttpServletResponse resp) throws IOException {
        int c;
        int cnt = 0;
        StringBuilder buf = new StringBuilder();
        while ((c = in.read()) != -1) {
            if (c == 13) continue;
            if (c == 10) {
                if (buf.length() <= 0) break;
                if (cnt == 0) {
                    int status = this.getStatusCode(buf.toString().trim());
                    if (status == -1) {
                        throw new IOException("Bug in RedirectServlet?");
                    }
                    if (this.trace) {
                        RedirectService.traceln(buf.toString());
                    }
                    resp.setStatus(status);
                } else {
                    this.setHeader(buf.toString().trim(), resp);
                }
                buf.setLength(0);
                ++cnt;
                continue;
            }
            buf.append((char)c);
        }
        ServletOutputStream out = resp.getOutputStream();
        try {
            if (this.trace) {
                RedirectService.traceln("");
                this.copyDebug(in, (OutputStream)out);
            } else {
                this.copy(in, (OutputStream)out);
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected void setHeader(String header, HttpServletResponse resp) {
        int p;
        if (this.trace) {
            RedirectService.traceln(header);
        }
        if ((p = header.indexOf(58)) > -1) {
            resp.setHeader(header.substring(0, p), header.substring(p + 1).trim());
        }
    }

    public static void traceln(String str) {
        System.out.println(str);
    }

    public static void trace(String str) {
        System.out.print(str);
    }

    public static void main(String[] args) {
        Matcher m = HTTP_RESP.matcher("HTTP/1.1 404 Not Found");
        if (m.matches()) {
            System.out.println(m.group(1));
            System.out.println(m.group(2));
        }
    }
}

