/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.gwt.GwtBundleActivator;

public class WebEngineGwtServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(WebEngineGwtServlet.class);
    public static boolean HOSTED_MODE = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Class.forName("com.google.gwt.dev.HostedMode");
            HOSTED_MODE = true;
        }
        catch (ReflectiveOperationException e) {
            HOSTED_MODE = false;
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        if (HOSTED_MODE) {
            return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        }
        return this._doGetSerializationPolicy(request, moduleBaseURL, strongName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy _doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String moduleId;
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                log.warn((Object)("Malformed moduleBaseURL: " + moduleBaseURL), (Throwable)ex);
                return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            }
        }
        if ((moduleId = new File(modulePath).getName()).length() == 0) {
            moduleId = "root";
        }
        File dir = GwtBundleActivator.GWT_ROOT;
        if (!(dir = new File(dir, moduleId)).isDirectory()) {
            log.warn((Object)("Could not find gwt resources in web/root.war/gwt for module " + moduleId));
            return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        }
        String path = SerializationPolicyLoader.getSerializationPolicyFileName((String)strongName);
        log.debug((Object)("Found gwt serialization policy file: " + path));
        File policyFile = new File(dir, path);
        if (!policyFile.isFile()) {
            log.warn((Object)("Could not find gwt serialization policy file for module " + moduleId + " [ " + path + " ]"));
            return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(policyFile);
            SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)in, null);
            return serializationPolicy;
        }
        catch (IOException e) {
            log.error((Object)("Failed to read gwt serialization policy file for module " + moduleId + " [ " + path + " ]"), (Throwable)e);
            SerializationPolicy serializationPolicy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            return serializationPolicy;
        }
        catch (ParseException e) {
            log.error((Object)("Failed to parse the policy file '" + policyFile + "'"), (Throwable)e);
            SerializationPolicy serializationPolicy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
            return serializationPolicy;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

