/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.webengine.gwt.GwtResolver;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class GwtBundleActivator
implements BundleActivator,
FrameworkListener {
    protected static final Log log = LogFactory.getLog(GwtBundleActivator.class);
    public static final String GWT_DEV_MODE_PROP = "nuxeo.gwt_dev_mode";
    public static final File GWT_ROOT = new File(Environment.getDefault().getWeb(), "root.war/gwt");
    public static final boolean GWT_DEV_MODE = "true".equals(Framework.getProperty((String)"nuxeo.gwt_dev_mode", (String)"false"));
    protected BundleContext context;

    public void start(BundleContext context) {
        this.context = context;
        if (GWT_DEV_MODE) {
            return;
        }
        context.addFrameworkListener((FrameworkListener)this);
    }

    public void stop(BundleContext context) {
        this.context = null;
    }

    protected void installGwtApp(Bundle bundle) throws IOException, URISyntaxException {
        URL location = bundle.getEntry("gwt-war");
        if (location == null) {
            throw new IOException("Cannot locate gwt-war in " + bundle.getSymbolicName());
        }
        ((GwtResolver)Framework.getService(GwtResolver.class)).install(location.toURI());
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            try {
                this.installGwtApp(this.context.getBundle());
            }
            catch (IOException | URISyntaxException cause) {
                throw new RuntimeException("Cannot start GWT", cause);
            }
        }
    }
}

