/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha.queues;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.platform.queue.api.QueueLocator;
import org.nuxeo.ecm.platform.queue.api.QueueManager;
import org.nuxeo.ecm.webengine.ha.HighAvailabilityObject;
import org.nuxeo.ecm.webengine.ha.queues.QueueObject;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Queues", administrator=Access.GRANT)
public class QueuesObject
extends HighAvailabilityObject {
    protected QueueLocator locator;
    protected Map<String, QueueManager<?>> queues;

    public static QueuesObject newObject(DefaultObject from) {
        return (QueuesObject)from.newObject("Queues", new Object[0]);
    }

    protected void initialize(Object ... args) {
        super.initialize(args);
        this.locator = (QueueLocator)Framework.getLocalService(QueueLocator.class);
        this.queues = new HashMap();
        for (QueueManager manager : this.locator.getManagers()) {
            this.queues.put(manager.getName().getSchemeSpecificPart(), manager);
        }
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    public Collection<QueueManager<?>> getQueues() {
        return this.queues.values();
    }

    @Path(value="{queue}")
    public Object doDispatch(@PathParam(value="queue") String name) {
        return QueueObject.newObject(this, this.queues.get(name));
    }
}

