/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha.statuses;

import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.management.api.ProbeInfo;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.webengine.ha.HighAvailabilityObject;
import org.nuxeo.ecm.webengine.ha.statuses.ProbeObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Probes")
@Produces(value={"text/html; charset=UTF-8"})
public class ProbesObject
extends HighAvailabilityObject {
    protected ProbeManager probeMgr;
    protected Collection<ProbeInfo> infos;

    public static ProbesObject newProbes(DefaultObject parent) {
        return (ProbesObject)parent.newObject("Probes", new Object[0]);
    }

    protected void initialize(Object ... args) {
        assert (args != null && args.length == 2);
        this.probeMgr = (ProbeManager)Framework.getLocalService(ProbeManager.class);
        this.infos = this.probeMgr.getAllProbeInfos();
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    public Collection<ProbeInfo> getInfos() {
        return this.infos;
    }

    @GET
    @Path(value="availability")
    @Produces(value={"text/plain"})
    public Object doGetAvailability() {
        this.probeMgr.runAllProbes();
        return this.getView("availability").arg("isAvailable", (Object)this.probeMgr.getProbesInError().isEmpty());
    }

    @Path(value="{probe}")
    public ProbeObject doGetProbe(@PathParam(value="probe") String name) {
        for (ProbeInfo info : this.infos) {
            if (!info.getShortcutName().equals(name)) continue;
            return ProbeObject.newProbe(this, info);
        }
        throw new WebResourceNotFoundException("No such probe " + name);
    }

    @PUT
    public Object doPut() {
        return this.doRun();
    }

    @GET
    @Path(value="/@run")
    public Object doRun() {
        this.probeMgr.runAllProbes();
        return this.redirect(this.getPath());
    }
}

