/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.ha.locks.LocksObject;
import org.nuxeo.ecm.webengine.ha.queues.QueuesObject;
import org.nuxeo.ecm.webengine.ha.statuses.StatusesObject;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@WebObject(type="HighAvailability")
@Produces(value={"text/html; charset=UTF-8"})
@Path(value="ha")
public class HighAvailabilityRoot
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(HighAvailabilityRoot.class);

    @Path(value="locks")
    public Object dispatchLock() {
        return LocksObject.newObject((DefaultObject)this);
    }

    @Path(value="queues")
    public Object dispatchQueues() {
        return QueuesObject.newObject((DefaultObject)this);
    }

    @Path(value="statuses")
    public Object dispatchStatuses() {
        return StatusesObject.newObject((DefaultObject)this);
    }

    @GET
    public Template doGet() {
        return this.getView("index");
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error_401.ftl")).type("text/html").build();
        }
        return super.handleError(e);
    }
}

