/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha.locks;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.nuxeo.ecm.platform.lock.api.LockInfo;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.ha.HighAvailabilityObject;
import org.nuxeo.ecm.webengine.ha.locks.LocksObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="Lock")
public class LockObject
extends HighAvailabilityObject {
    protected LockInfo info;

    public static LockObject newLock(DefaultObject from, LockInfo info) {
        return (LockObject)from.newObject("Lock", new Object[]{info});
    }

    protected void initialize(Object ... args) {
        assert (args != null && args.length > 0);
        this.info = (LockInfo)args[0];
    }

    public LockInfo getInfo() {
        return this.info;
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @DELETE
    public Object doDelete() {
        return this.doUnlock();
    }

    @POST
    @Path(value="@unlock")
    public Object doUnlock() {
        try {
            this.info.unlock();
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Cannot unlock " + this.info.getResource()), (Throwable)e);
        }
        return LocksObject.newObject(this);
    }
}

