/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha.locks;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.platform.lock.api.LockInfo;
import org.nuxeo.ecm.platform.lock.api.LockReader;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.ha.HighAvailabilityObject;
import org.nuxeo.ecm.webengine.ha.locks.LockObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Locks")
public class LocksObject
extends HighAvailabilityObject {
    protected LockReader reader;
    protected List<LockInfo> infos;

    public static LocksObject newObject(DefaultObject parent) {
        return (LocksObject)parent.newObject("Locks", new Object[0]);
    }

    protected void initialize(Object ... args) {
        super.initialize(args);
        this.reader = (LockReader)Framework.getLocalService(LockReader.class);
        try {
            this.infos = this.reader.getInfos();
        }
        catch (InterruptedException e) {
            throw WebException.wrap((String)"Unavailable infos", (Throwable)e);
        }
    }

    public List<LockInfo> getInfos() {
        return this.infos;
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @Path(value="{resource}")
    public HighAvailabilityObject dispatch(@PathParam(value="resource") String resource) {
        for (LockInfo info : this.infos) {
            if (!info.getResource().toASCIIString().equals(resource)) continue;
            return LockObject.newLock(this, info);
        }
        throw new WebResourceNotFoundException("No locks on " + resource);
    }
}

