/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ha.queues;

import java.io.Serializable;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.queue.api.QueueInfo;
import org.nuxeo.ecm.platform.queue.api.QueueManager;
import org.nuxeo.ecm.webengine.ha.HighAvailabilityObject;
import org.nuxeo.ecm.webengine.ha.queues.QueueInfoObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="Queue")
public class QueueObject<C extends Serializable>
extends HighAvailabilityObject {
    protected static Log log = LogFactory.getLog(QueueObject.class);
    protected QueueManager<C> manager;
    protected List<QueueInfo<C>> infos;

    public static <C extends Serializable> QueueObject<C> newObject(DefaultObject from, QueueManager<C> manager) {
        return (QueueObject)from.newObject("Queue", new Object[]{manager});
    }

    protected void initialize(Object ... args) {
        super.initialize(args);
        this.manager = (QueueManager)args[0];
        this.infos = this.manager.listKnownContent();
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @GET
    @Path(value="@blacklist")
    public Object doGetCancel() {
        for (QueueInfo<C> info : this.infos) {
            if (info.isBlacklisted()) continue;
            info.blacklist();
        }
        return this.redirect(this.getPath());
    }

    @GET
    @Path(value="@retry")
    public Object doGetRetry() {
        for (QueueInfo<C> info : this.infos) {
            if (!info.isFailed() && !info.isOrphaned()) continue;
            info.retry();
        }
        return this.redirect(this.getPath());
    }

    @GET
    @Path(value="@purge")
    public Object doGetPurge() {
        for (QueueInfo<C> info : this.infos) {
            if (!info.isBlacklisted()) continue;
            info.purge();
        }
        return this.redirect(this.getPath());
    }

    public List<QueueInfo<C>> getInfos() {
        return this.infos;
    }

    public QueueManager<C> getManager() {
        return this.manager;
    }

    @Path(value="{content}")
    public Object doDispatch(@PathParam(value="content") String name) {
        for (QueueInfo<C> info : this.infos) {
            if (!info.getName().getFragment().equals(name)) continue;
            return QueueInfoObject.newObject(this, this.manager, info);
        }
        throw new WebResourceNotFoundException("Couldn't find the content " + name);
    }
}

