/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import com.sun.jersey.server.impl.provider.RuntimeDelegateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationProxy;
import org.nuxeo.ecm.webengine.jaxrs.CompositeApplication;
import org.nuxeo.ecm.webengine.jaxrs.Reloadable;
import org.nuxeo.ecm.webengine.jaxrs.servlet.JerseyServlet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    private static final Log log = LogFactory.getLog(Activator.class);
    private static Activator instance;
    protected ServiceTracker httpServiceTracker;
    protected BundleContext context;
    protected BundleTracker tracker;
    protected ServiceReference pkgAdm;
    protected CompositeApplication app;
    protected List<Reloadable> toReload;

    public static Activator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        instance = this;
        this.context = context;
        this.toReload = new Vector<Reloadable>();
        this.app = new CompositeApplication();
        this.pkgAdm = context.getServiceReference(PackageAdmin.class.getName());
        this.tracker = new BundleTracker(context, 44, (BundleTrackerCustomizer)this);
        this.tracker.open();
        if (!"Nuxeo".equals(context.getProperty("org.osgi.framework.vendor"))) {
            this.httpServiceTracker = new ServiceTracker(context, HttpService.class.getName(), (ServiceTrackerCustomizer)this);
            this.httpServiceTracker.open();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        ServletRegistry.dispose();
        instance = null;
        context.ungetService(this.pkgAdm);
        this.pkgAdm = null;
        this.tracker.close();
        this.tracker = null;
        this.toReload = null;
        this.app = null;
        this.context = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.context.getService(this.pkgAdm);
    }

    public CompositeApplication getApplication() {
        return this.app;
    }

    public void addReloadListener(Reloadable reloadable) {
        this.toReload.add(reloadable);
    }

    public void removeReloadListener(Reloadable reloadable) {
        this.toReload.remove(reloadable);
    }

    public void reload() {
        for (Reloadable reloadable : this.toReload.toArray(new Reloadable[this.toReload.size()])) {
            reloadable.reload();
        }
        this.app.reload();
        JerseyServlet.invalidate();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        String v = (String)bundle.getHeaders().get("Nuxeo-WebModule");
        if (v != null) {
            String className = null;
            HashMap<String, String> vars = new HashMap();
            String varsStr = null;
            int i = v.indexOf(59);
            if (i > -1) {
                className = v.substring(0, i).trim();
                varsStr = v.substring(i + 1).trim();
            } else {
                className = v.trim();
            }
            if (varsStr != null) {
                vars = this.parseAttrs(varsStr);
            }
            try {
                ApplicationProxy ba = new ApplicationProxy(bundle, className, vars);
                this.app.add(ba);
                this.reload();
                return ba;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.reload();
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.app.remove((ApplicationProxy)((Object)object));
        this.reload();
    }

    protected Map<String, String> parseAttrs(String expr) {
        String[] ar;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String a : ar = StringUtils.split((String)expr, (char)';', (boolean)true)) {
            int i = a.indexOf(61);
            if (i == -1) {
                map.put(a, null);
                continue;
            }
            String key = a.substring(0, i).trim();
            String val = a.substring(i + 1).trim();
            if (key.endsWith(":")) {
                key = key.substring(0, key.length() - 1).trim();
            }
            map.put(key, val);
        }
        return map;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        try {
            if (service instanceof HttpService) {
                ServletRegistry.getInstance().initHttpService((HttpService)service);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize http service", e);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        try {
            if (ServletRegistry.getInstance().getHttpService() == service) {
                ServletRegistry.getInstance().initHttpService(null);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove http service", (Throwable)e);
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        try {
            if (ServletRegistry.getInstance().getHttpService() == service) {
                ServletRegistry.getInstance().initHttpService(null);
                ServletRegistry.getInstance().initHttpService((HttpService)service);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to update http service", (Throwable)e);
        }
    }
}

