/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFactory;
import org.osgi.framework.Bundle;

public class ApplicationProxy
extends Application {
    protected final Bundle bundle;
    protected final String className;
    protected final Map<String, String> attrs;
    protected volatile Application delegate;

    public ApplicationProxy(Bundle bundle, String className, Map<String, String> attrs) {
        this.bundle = bundle;
        this.className = className;
        this.attrs = attrs;
    }

    public String getClassName() {
        return this.className;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void reset() {
        this.delegate = null;
    }

    public Application get() {
        block5: {
            if (this.delegate == null) {
                try {
                    Object obj = this.bundle.loadClass(this.className).newInstance();
                    if (obj instanceof ApplicationFactory) {
                        this.delegate = ((ApplicationFactory)obj).getApplication(this.bundle, this.attrs);
                        break block5;
                    }
                    if (obj instanceof Application) {
                        this.delegate = (Application)obj;
                        break block5;
                    }
                    throw new IllegalArgumentException("Expecting an Application or ApplicationFactory class: " + this.className);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate JAX-RS application " + this.className + " from bundle " + this.bundle.getSymbolicName(), e);
                }
            }
        }
        return this.delegate;
    }

    public Set<Class<?>> getClasses() {
        return this.get().getClasses();
    }

    public Set<Object> getSingletons() {
        return this.get().getSingletons();
    }
}

