/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.mapping;

import java.util.Arrays;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.PathParser;

public final class Path {
    public static final int HAS_LEADING_SLASH = 1;
    public static final int HAS_TRAILING_SLASH = 2;
    public static final String[] EMPTY_SEGMENTS = new String[0];
    public static final Path ROOT = new Path(EMPTY_SEGMENTS, 3);
    public static final Path EMPTY = new Path(EMPTY_SEGMENTS);
    protected int bits;
    protected final String[] segments;

    public static Path parse(String path) {
        return new PathParser().parse(path);
    }

    public Path(String[] segments) {
        this(segments, 0);
    }

    public Path(String[] segments, int bits) {
        this(segments, bits, true);
    }

    protected Path(String[] segments, int bits, boolean updateHashCode) {
        this.segments = segments;
        this.bits = bits;
        if (updateHashCode) {
            this.updateHashCode();
        }
    }

    public int length() {
        return this.segments.length;
    }

    public String[] segments() {
        return this.segments;
    }

    public final boolean hasLeadingSlash() {
        return (this.bits & 1) == 1;
    }

    public final boolean hasTrailingSlash() {
        return (this.bits & 2) == 2;
    }

    public final boolean isAbsolute() {
        return (this.bits & 1) == 1;
    }

    public Path copy() {
        return new Path(this.segments, this.bits, false);
    }

    public Path copy(int bits) {
        return new Path(this.segments, bits & 0xFFFFFFFC | bits & 3, false);
    }

    public String toString() {
        int len = this.segments.length;
        if (len == 0) {
            return this.hasLeadingSlash() || this.hasTrailingSlash() ? "/" : "";
        }
        StringBuilder buf = new StringBuilder(this.segments.length * 16);
        if (this.hasLeadingSlash()) {
            buf.append('/');
        }
        buf.append(this.segments[0]);
        for (int i = 1; i < this.segments.length; ++i) {
            buf.append('/').append(this.segments[i]);
        }
        if (this.hasTrailingSlash()) {
            buf.append('/');
        }
        return buf.toString();
    }

    public String lastSegment() {
        return this.segments.length == 0 ? "" : this.segments[this.segments.length - 1];
    }

    public String getFileExtension() {
        if (this.segments.length == 0) {
            return null;
        }
        String last = this.segments[this.segments.length - 1];
        int i = last.lastIndexOf(46);
        return i > -1 ? last.substring(i + 1) : null;
    }

    public String getFileName() {
        if (this.segments.length == 0) {
            return "";
        }
        String last = this.segments[this.segments.length - 1];
        int i = last.lastIndexOf(46);
        return i > -1 ? last.substring(0, i) : null;
    }

    public Path append(String segment) {
        String[] ar = new String[this.segments.length];
        System.arraycopy(this.segments, 0, ar, 0, this.segments.length);
        return new Path(this.segments, this.bits);
    }

    public Path makeAbsolute() {
        return this.hasLeadingSlash() ? this : new Path(this.segments, this.bits | 1);
    }

    public Path makeRelative() {
        return this.hasLeadingSlash() ? new Path(this.segments, this.bits & 0xFFFFFFFE) : this;
    }

    public Path removeTrailingSlash() {
        return this.hasTrailingSlash() ? new Path(this.segments, this.bits & 0xFFFFFFFD) : this;
    }

    public boolean isRoot() {
        return this.segments.length == 0 && this.hasLeadingSlash();
    }

    public String segment(int i) {
        return this.segments[i];
    }

    public Path removeLastSegment() {
        return this.removeLastSegments(1);
    }

    public Path removeLastSegments(int i) {
        String[] ar = new String[this.segments.length];
        System.arraycopy(this.segments, 0, ar, 0, this.segments.length);
        return new Path(this.segments, this.bits);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == Path.class) {
            Path path = (Path)obj;
            return path.bits == this.bits && Arrays.equals(path.segments, this.segments);
        }
        return false;
    }

    public int hashCode() {
        return this.bits;
    }

    private void updateHashCode() {
        this.bits = this.bits & 3 | this.computeHashCode() << 2;
    }

    private int computeHashCode() {
        int hash = 17;
        int segmentCount = this.segments.length;
        for (int i = 0; i < segmentCount; ++i) {
            hash = hash * 37 + this.segments[i].hashCode();
        }
        return hash;
    }
}

