/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.views;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.webengine.jaxrs.views.View;

public class TemplateView
extends View {
    private static final FreemarkerEngine engine = new FreemarkerEngine(null, (ResourceLocator)new Locator());
    private static final Map<String, TemplateView> locators = new HashMap<String, TemplateView>();

    public TemplateView(String name) {
        this(null, name);
    }

    public TemplateView(Object owner, String name) {
        super(owner, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Writer writer) throws Exception {
        String id = TemplateView.addLocator(this);
        try {
            engine.render(id, (Object)this.vars, writer);
            writer.flush();
        }
        finally {
            TemplateView.removeLocator(id);
        }
    }

    @Override
    public void render(OutputStream out) throws Exception {
        this.render(new OutputStreamWriter(out, "UTF-8"));
    }

    private static synchronized String addLocator(TemplateView view) {
        String locatorId = "view:/" + view.getUrl().toExternalForm();
        locators.put(locatorId, view);
        return locatorId;
    }

    private static synchronized void removeLocator(String id) {
        locators.remove(id);
    }

    private static synchronized TemplateView getLocator(String id) {
        return locators.get(id);
    }

    static class Locator
    implements ResourceLocator {
        Locator() {
        }

        public File getResourceFile(String key) {
            return null;
        }

        public URL getResourceURL(String key) {
            TemplateView view = TemplateView.getLocator(key);
            if (view != null) {
                return view.getUrl();
            }
            return null;
        }
    }
}

