/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.views;

import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationHost;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.osgi.framework.Bundle;

public class ResourceContext {
    private static ThreadLocal<ResourceContext> perThreadContext = new ThreadLocal();
    protected ApplicationHost app;
    protected HttpServletRequest request;
    protected UriInfo uriInfo;
    private LinkedList<Bundle> bundleStack;
    private CoreSession session;

    public static final void setContext(ResourceContext context) {
        perThreadContext.set(context);
    }

    public static final ResourceContext getContext() {
        return perThreadContext.get();
    }

    public static final void destroyContext() {
        perThreadContext.remove();
    }

    protected ResourceContext() {
    }

    public ResourceContext(ApplicationHost app) {
        this.app = app;
        this.bundleStack = new LinkedList();
    }

    public ApplicationHost getApplication() {
        return this.app;
    }

    public final LinkedList<Bundle> getBundleStack() {
        return this.bundleStack;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public final Bundle getBundle() {
        return this.bundleStack.isEmpty() ? null : this.bundleStack.get(this.bundleStack.size() - 1);
    }

    public final RenderingEngine getRenderingEngine() {
        return this.app.getRendering();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Principal getPrincipal() {
        return this.request.getUserPrincipal();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public CoreSession getSession() {
        if (this.session == null) {
            this.session = SessionFactory.getSession(this.request);
        }
        return this.session;
    }

    public URI getBaseUri() {
        return this.uriInfo.getBaseUri();
    }

    public void pushBundleFor(Object obj) {
        Bundle b = this.getResourceBundle(obj);
        if (b != null) {
            this.pushBundle(b);
        }
    }

    public void pushBundle(Bundle bundle) {
        for (Bundle b : this.bundleStack) {
            if (b != bundle) continue;
            return;
        }
        this.bundleStack.add(bundle);
    }

    protected Bundle getResourceBundle(Object res) {
        return this.app.getBundle(res.getClass());
    }

    public String getViewRoot() {
        return this.bundleStack.isEmpty() ? "" : "view:" + this.bundleStack.get(this.bundleStack.size() - 1).getBundleId() + ":/";
    }

    public URL findEntry(String path) {
        int p;
        if (path.startsWith("view:") && (p = path.indexOf(":/")) > -1) {
            path = path.substring(p + 2);
        }
        for (int i = this.bundleStack.size() - 1; i >= 0; --i) {
            URL url = this.bundleStack.get(i).getEntry(path);
            if (url == null) continue;
            return url;
        }
        return null;
    }
}

