/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFactory;
import org.osgi.framework.Bundle;

public class ApplicationFragment
extends Application {
    protected final String hostName;
    protected final Bundle bundle;
    protected final Map<String, String> attrs;
    protected String appClass;
    private volatile Application app;

    public static Map<String, String> createAttributes(String hostName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (hostName != null) {
            attrs.put("host", hostName);
        }
        return attrs;
    }

    public ApplicationFragment(Bundle bundle, String appClass) {
        this(bundle, appClass, (String)null);
    }

    public ApplicationFragment(Bundle bundle, String appClass, String host) {
        this(bundle, appClass, ApplicationFragment.createAttributes(host));
    }

    public ApplicationFragment(Bundle bundle, String appClass, Map<String, String> attrs) {
        this.bundle = bundle;
        this.appClass = appClass;
        this.attrs = attrs;
        String host = attrs.get("host");
        this.hostName = host == null ? "default" : host;
    }

    protected synchronized void createApp() {
        block4: {
            try {
                Object obj = this.bundle.loadClass(this.appClass).newInstance();
                if (obj instanceof ApplicationFactory) {
                    this.app = ((ApplicationFactory)obj).getApplication(this.bundle, this.attrs);
                    break block4;
                }
                if (obj instanceof Application) {
                    this.app = (Application)obj;
                    break block4;
                }
                throw new IllegalArgumentException("Expecting an Application or ApplicationFactory class: " + this.appClass);
            }
            catch (Exception e) {
                String msg = "Cannot instantiate JAX-RS application " + this.appClass + " from bundle " + this.bundle.getSymbolicName();
                throw new RuntimeException(msg, e);
            }
        }
    }

    public synchronized void reload() throws Exception {
        this.app = null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Application get() {
        if (this.app == null) {
            this.createApp();
        }
        return this.app;
    }

    public Set<Class<?>> getClasses() {
        return this.get().getClasses();
    }

    public Set<Object> getSingletons() {
        return this.get().getSingletons();
    }
}

