/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.utils;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationHelper;
import org.nuxeo.webengine.sites.utils.SiteConstants;
import org.nuxeo.webengine.sites.utils.WordExtractor;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.common.CommonWikiParser;

public class SitesRelationsWikiHelper {
    public static final Resource HAS_LINK_TO = new ResourceImpl("http://www.nuxeo.org/sitesWiki/hasLinkTo");

    private SitesRelationsWikiHelper() {
    }

    public static void updateRelations(DocumentModel doc, List<String> linksList) throws ClientException {
        StatementImpl stmt;
        List<String> list = SitesRelationsWikiHelper.getWordLinks(doc);
        ArrayList<StatementImpl> stmts = RelationHelper.getStatements((DocumentModel)doc, (Resource)HAS_LINK_TO);
        RelationManager rm = RelationHelper.getRelationManager();
        if (stmts != null) {
            rm.remove("default", (List)stmts);
            stmts.clear();
        } else {
            stmts = new ArrayList<StatementImpl>();
        }
        QNameResource docResource = RelationHelper.getDocumentResource((DocumentModel)doc);
        String basePath = (String)((Object)doc.getContextData("basePath"));
        String siteName = (String)((Object)doc.getContextData("siteName"));
        String targetBasePath = (String)((Object)doc.getContextData("targetObjectPath"));
        for (String word : list) {
            word = word.startsWith(".") ? basePath + "/" + siteName + word.replace(".", "/") : targetBasePath + "/" + word;
            stmt = new StatementImpl((Node)docResource, (Node)HAS_LINK_TO, (Node)new LiteralImpl(word));
            stmts.add(stmt);
        }
        for (String word : linksList) {
            stmt = new StatementImpl((Node)docResource, (Node)HAS_LINK_TO, (Node)new LiteralImpl(word));
            stmts.add(stmt);
        }
        rm.add("default", stmts);
    }

    public static List<String> getWordLinks(DocumentModel doc) {
        try {
            String content = (String)((Object)doc.getPropertyValue("webp:content"));
            StringBuffer collector = new StringBuffer();
            WordExtractor extractor = new WordExtractor(collector);
            CommonWikiParser parser = new CommonWikiParser();
            try {
                parser.parse((Reader)new StringReader(content), (IWemListener)extractor);
            }
            catch (WikiParserException e) {
                e.printStackTrace();
            }
            return SitesRelationsWikiHelper.getWordLinks(collector.toString());
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    public static List<String> getWordLinks(String text) {
        ArrayList<String> wordLinks = new ArrayList<String>();
        Matcher matcher = SiteConstants.PAGE_LINK_PATTERN.matcher(text);
        while (matcher.find()) {
            String s = matcher.group(0);
            if (wordLinks.contains(s)) continue;
            wordLinks.add(s);
        }
        return wordLinks;
    }
}

