/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webengine.sites.utils.SiteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="AbstractSiteDocumentObject", superType="Document", facets={"AbstractSiteDocumentObject"})
@Produces(value={"text/html; charset=UTF-8"})
public abstract class AbstractSiteDocumentObject
extends DocumentObject {
    private static final Log log = LogFactory.getLog(AbstractSiteDocumentObject.class);

    @GET
    public Object doGet() {
        if (this.doc == null) {
            return this.getTemplate(this.getErrorTemplateName()).args(this.getErrorArguments());
        }
        this.setDoGetParameters();
        try {
            return this.getTemplate("template_default.ftl").args(this.getArguments());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="logo")
    public Response getLogo() {
        Response resp = null;
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            resp = SiteUtils.getLogoResponse(parentWebSite);
        }
        catch (Exception e) {
            log.error((Object)("Problems retriveing the log for" + this.doc.getName()), (Throwable)e);
        }
        if (resp == null) {
            resp = this.redirect(this.getContext().getModule().getSkinPathPrefix() + "/images/logo.gif");
        }
        return resp;
    }

    @GET
    @Path(value="welcomeMedia")
    public Response getWelcomeMedia() {
        Response resp = null;
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            Blob blob = SiteUtils.getBlob(parentWebSite, "webc:welcomeMedia");
            if (blob != null) {
                resp = Response.ok().entity((Object)blob).type(blob.getMimeType()).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to display the website. ", (Throwable)e);
        }
        if (resp == null) {
            resp = this.redirect(this.getContext().getModule().getSkinPathPrefix() + "/images/logo.gif");
        }
        return resp;
    }

    @POST
    @GET
    @Path(value="search")
    public Object getSearchParameters(@FormParam(value="searchParam") String searchParam) {
        this.setSearchParameters(searchParam);
        try {
            return this.getTemplate("template_default.ftl").args(this.getArguments());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        try {
            return this.newDocument(path);
        }
        catch (Exception e) {
            if (e instanceof WebResourceNotFoundException) {
                CoreSession session = this.ctx.getCoreSession();
                try {
                    if (session.hasPermission(this.doc.getRef(), "AddChildren")) {
                        DocumentObject parent = (DocumentObject)this.ctx.getTargetObject();
                        this.ctx.getRequest().setAttribute("org.nuxeo.theme.perspective", (Object)"create");
                        this.ctx.getRequest().setAttribute("pageName", (Object)path);
                        return parent;
                    }
                    return this.newObject(this.getWebPageDocumentType(), new Object[]{path});
                }
                catch (ClientException ce) {
                    throw WebException.wrap((Throwable)ce);
                }
            }
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    @Path(value="createWebPage")
    public Object createWebPage() {
        try {
            CoreSession session = this.ctx.getCoreSession();
            DocumentModel createdDocument = SiteUtils.createDocument(this.ctx.getRequest(), session, this.doc.getPathAsString(), this.getWebPageDocumentType());
            DocumentModel parentWebSite = this.getParentWebSite(session);
            String path = SiteUtils.getPagePath(parentWebSite, createdDocument);
            return this.redirect(path);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="homePagePath")
    public Object getHomePagePath() {
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            StringBuilder path = new StringBuilder(SiteUtils.getWebContainersPath()).append("/");
            path.append(SiteUtils.getString(parentWebSite, "webc:url"));
            return this.redirect(path.toString());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected String getWebSiteDocumentType() {
        return "WebSite";
    }

    protected String getWebPageDocumentType() {
        return "WebPage";
    }

    protected void setSearchParameters(String searchParam) {
        this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)this.getSearchThemePage());
        this.ctx.setProperty("searchParam", (Object)searchParam);
        this.ctx.setProperty("searchParamDocType", (Object)this.getWebPageDocumentType());
    }

    protected Map<String, Object> getArguments() throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        DocumentModel parentWebSite = this.getParentWebSite(this.getCoreSession());
        root.put("name", SiteUtils.getString(parentWebSite, "webc:name", null));
        root.put("siteDescription", SiteUtils.getString(parentWebSite, "webcontainer:baseline", null));
        root.put("siteCreatorEmail", "mailto:" + parentWebSite.getPropertyValue("webc:email").toString());
        MimetypeRegistry mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        root.put("mimetypeService", mimetypeService);
        return root;
    }

    protected void setDoGetParameters() {
        String theme = SiteUtils.getString(this.doc, this.getSchemaFieldThemeName(), this.getDefaultSchemaFieldThemeValue());
        String themePage = SiteUtils.getString(this.doc, this.getSchemaFieldThemePageName(), this.getDefaultSchemaFieldThemePageValue());
        this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)(theme + "/" + themePage));
        String currentPerspective = (String)this.ctx.getRequest().getAttribute("org.nuxeo.theme.perspective");
        if (StringUtils.isEmpty((String)currentPerspective)) {
            this.ctx.getRequest().setAttribute("org.nuxeo.theme.perspective", (Object)"view");
        }
    }

    protected DocumentModel getParentWebSite(CoreSession session) throws Exception {
        DocumentModel parentWebSite = null;
        parentWebSite = !this.doc.hasFacet("WebView") ? SiteUtils.getFirstWebSiteParent(session, this.doc) : this.doc;
        return parentWebSite;
    }

    protected abstract String getSearchThemePage();

    protected abstract String getSchemaFieldThemeName();

    protected abstract String getSchemaFieldThemePageName();

    protected abstract String getDefaultSchemaFieldThemeValue();

    protected abstract String getDefaultSchemaFieldThemePageValue();

    protected abstract String getErrorTemplateName();

    protected abstract Map<String, Object> getErrorArguments();
}

