/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.webengine.sites.models.CommentModel;
import org.nuxeo.webengine.sites.models.WebpageModel;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

@WebAdapter(name="rss", type="RssAdapter", targetType="Document")
@Produces(value={"application/rss+xml; charset=UTF-8"})
public class RssAdapter
extends DefaultAdapter {
    public static final int NO_PAGES = 15;
    public static final int NO_COMMENTS = 15;

    @GET
    @Path(value="rssOnPage")
    @Produces(value={"application/rss+xml"})
    public Template getFeed() {
        try {
            LinkedList<String> entries = new LinkedList<String>();
            Template rssEntryTpl = this.getTemplate("includes/rss_item.ftl");
            CoreSession session = this.ctx.getCoreSession();
            String docId = this.ctx.getRequest().getParameter("docId");
            StringBuilder baseUrl = this.ctx.getServerURL();
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            DocumentModelList paged = SiteQueriesColection.queryLastModifiedPages(session, doc.getPathAsString(), this.getWebPageDocumentType(), 15);
            for (DocumentModel documentModel : paged) {
                StringBuilder path = new StringBuilder(baseUrl);
                String pagePath = null;
                if (doc.getType().equals(this.getWebSiteDocumentType())) {
                    pagePath = new String(path.append(SiteUtils.getPagePath(doc, documentModel)));
                } else if (doc.getType().equals(this.getWebPageDocumentType())) {
                    pagePath = new String(baseUrl.append(SiteUtils.getPagePath(SiteUtils.getFirstWebSiteParent(session, doc), documentModel)));
                }
                WebpageModel wpmodel = new WebpageModel(documentModel.getName(), pagePath);
                wpmodel.setDescription((String)((Object)documentModel.getPropertyValue("dc:description")));
                String entryXml = rssEntryTpl.arg("item", (Object)wpmodel).render();
                entries.add(entryXml);
            }
            return this.getTemplate("rss_feed.ftl").args(SiteUtils.getRssFeedArguments(this.ctx, "title.last.published.pages")).arg("items", entries);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="rssOnComments")
    @Produces(value={"application/rss+xml"})
    public Template getCommentsFeed() {
        try {
            LinkedList<String> entries = new LinkedList<String>();
            Template rssEntryTpl = this.getTemplate("includes/rss_comment_item.ftl");
            CoreSession session = this.ctx.getCoreSession();
            CommentModel commentModel = null;
            String creationDate = null;
            String author = null;
            String commentText = null;
            DocumentModelList comments = null;
            String docId = this.ctx.getRequest().getParameter("docId");
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            if (doc.getType().equals(this.getWebSiteDocumentType())) {
                comments = SiteQueriesColection.queryLastComments(session, doc.getPathAsString(), 15, SiteUtils.isCurrentModerated(session, doc));
            } else if (doc.getType().equals(this.getWebPageDocumentType())) {
                CommentManager commentManager = SiteUtils.getCommentManager();
                comments = new DocumentModelListImpl(commentManager.getComments(doc));
            }
            for (DocumentModel documentModel : comments) {
                if (!"moderation_published".equals(documentModel.getCurrentLifeCycleState())) continue;
                GregorianCalendar modificationDate = (GregorianCalendar)documentModel.getProperty("comment:creationDate").getValue();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMM", WebEngine.getActiveContext().getLocale());
                creationDate = simpleDateFormat.format(modificationDate.getTime());
                author = (String)((Object)documentModel.getProperty("comment:author").getValue());
                commentText = (String)((Object)documentModel.getProperty("comment:text").getValue());
                commentModel = new CommentModel(creationDate, author, commentText, documentModel.getRef().toString(), false);
                String entryXml = rssEntryTpl.arg("item", (Object)commentModel).render();
                entries.add(entryXml);
            }
            return this.getTemplate("rss_feed.ftl").args(SiteUtils.getRssFeedArguments(this.ctx, "title.last.published.comments")).arg("items", entries);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private String getWebSiteDocumentType() throws ClientException {
        try {
            return (String)this.getTarget().getClass().getMethod("getWebSiteDocumentType", new Class[0]).invoke((Object)this.getTarget(), new Object[0]);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    private String getWebPageDocumentType() throws ClientException {
        try {
            return (String)this.getTarget().getClass().getMethod("getWebPageDocumentType", new Class[0]).invoke((Object)this.getTarget(), new Object[0]);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

