/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="sites", facets={"Sites"})
@Produces(value={"text/html; charset=UTF-8"})
public class Sites
extends DefaultObject {
    private static final Log log = LogFactory.getLog(Sites.class);

    @GET
    public Object doGet() {
        return this.dispatch("/");
    }

    @Path(value="{modulePath}")
    public Object dispatch(@PathParam(value="modulePath") String path) {
        try {
            if ("/".equals(path)) {
                List<Object> sites = this.getWebContainers();
                WebContext context = WebEngine.getActiveContext();
                CoreSession session = context.getCoreSession();
                this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)this.getThemePage());
                return this.getTemplate("list_sites.ftl").arg("sites", sites).arg("rootDoc", (Object)session.getRootDocument());
            }
            return this.newObject(this.getWebSiteObjectTypeName(), new Object[]{path});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public List<Object> getWebContainers() throws Exception {
        WebContext context = WebEngine.getActiveContext();
        CoreSession session = context.getCoreSession();
        DocumentModelList webSites = SiteQueriesColection.queryAllSites(session, this.getWebSiteDocumentType());
        ArrayList<Object> sites = new ArrayList<Object>();
        for (DocumentModel webSite : webSites) {
            try {
                HashMap<String, String> site = new HashMap<String, String>();
                site.put("href", SiteUtils.getString(webSite, "webc:url"));
                site.put("name", SiteUtils.getString(webSite, "webc:name"));
                sites.add(site);
            }
            catch (Exception e) {
                log.error((Object)"Problem retrieving the existings websites ...", (Throwable)e);
            }
        }
        return sites;
    }

    protected String getThemePage() {
        return "sites/default";
    }

    public String getWebSiteDocumentType() {
        return "WebSite";
    }

    public String getWebSiteObjectTypeName() {
        return "WebSite";
    }

    public String getWebPageDocumentType() {
        return "WebPage";
    }
}

