/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.text.SimpleDateFormat;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.JsonAdapter;
import org.nuxeo.webengine.sites.models.WebpageCommentListModel;
import org.nuxeo.webengine.sites.models.WebpageCommentModel;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class MinisiteLastCommentsFragment
extends AbstractFragment {
    private int noComments = 5;
    private int noWordsFromContent = 50;

    public Model getModel() throws ModelException {
        WebpageCommentListModel model = new WebpageCommentListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            WebpageCommentModel webpageCommentModel = null;
            DocumentModel parentPage = null;
            SimpleDateFormat simpleDateFormat = null;
            String pageTitle = null;
            String pagePath = null;
            String content = null;
            String author = null;
            try {
                DocumentModel ws = SiteUtils.getFirstWebSiteParent(session, documentModel);
                DocumentModelList comments = SiteQueriesColection.queryLastComments(session, ws.getPathAsString(), this.noComments, SiteUtils.isCurrentModerated(session, ws));
                for (DocumentModel comment : comments) {
                    parentPage = SiteUtils.getPageForComment(comment);
                    author = SiteUtils.getUserDetails(SiteUtils.getString(comment, "comment:author"));
                    if (parentPage != null) {
                        pageTitle = parentPage.getTitle();
                        pagePath = JsonAdapter.getRelativPath(ws, parentPage).toString();
                    }
                    content = SiteUtils.getFistNWordsFromString(SiteUtils.getString(comment, "comment:text"), this.noWordsFromContent);
                    simpleDateFormat = new SimpleDateFormat("dd MMMM", WebEngine.getActiveContext().getLocale());
                    String formattedString = simpleDateFormat.format(SiteUtils.getGregorianCalendar(comment, "comment:creationDate").getTime());
                    String[] splittedFormatterdString = formattedString.split(" ");
                    webpageCommentModel = new WebpageCommentModel(pageTitle, pagePath, content, author, splittedFormatterdString[0], splittedFormatterdString[1]);
                    model.addItem((Model)webpageCommentModel);
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }
}

