/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.webengine.sites.AbstractSiteDocumentObject;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="WebSite", superType="AbstractSiteDocumentObject", facets={"WebSite"})
@Produces(value={"text/html; charset=UTF-8"})
public class Site
extends AbstractSiteDocumentObject {
    private static final Log log = LogFactory.getLog(Site.class);
    protected String url;

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        this.url = (String)args[0];
        this.doc = this.getSiteDocumentModelByUrl(this.url);
    }

    @Path(value="{page}")
    public Object doGet(@PathParam(value="page") String page) {
        try {
            DocumentModel pageDoc = this.ctx.getCoreSession().getChild(this.doc.getRef(), page);
            this.setDoGetParameters();
            return this.ctx.newObject(pageDoc.getType(), new Object[]{pageDoc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Override
    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        return super.traverse(path);
    }

    protected DocumentModel getSiteDocumentModelByUrl(String url) {
        WebContext context = WebEngine.getActiveContext();
        CoreSession session = context.getCoreSession();
        try {
            DocumentModelList list = SiteQueriesColection.querySitesByUrlAndDocType(session, url, this.getWebSiteDocumentType());
            if (list.size() != 0) {
                return (DocumentModel)list.get(0);
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to retrive the webcontainer ", (Throwable)e);
        }
        return null;
    }

    @Override
    protected String getSchemaFieldThemeName() {
        return "webc:theme";
    }

    @Override
    protected String getDefaultSchemaFieldThemeValue() {
        return "sites";
    }

    @Override
    protected String getSchemaFieldThemePageName() {
        return "webc:themePage";
    }

    @Override
    protected String getDefaultSchemaFieldThemePageValue() {
        return "workspace";
    }

    @Override
    protected Map<String, Object> getErrorArguments() {
        HashMap<String, Object> errorArguments = new HashMap<String, Object>();
        errorArguments.put("url", this.url);
        return errorArguments;
    }

    @Override
    protected String getErrorTemplateName() {
        return "no_site.ftl";
    }

    @Override
    protected String getSearchThemePage() {
        return "sites/search";
    }
}

