/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.CommentListModel;
import org.nuxeo.webengine.sites.models.CommentModel;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class PageLastCommentsFragment
extends AbstractFragment {
    public Model getModel() throws ModelException {
        CommentListModel model = new CommentListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            CommentModel commentModel = null;
            String creationDate = null;
            String author = null;
            String commentText = null;
            try {
                SimpleDateFormat simpleDateFormat;
                GregorianCalendar modificationDate;
                CommentManager commentManager = SiteUtils.getCommentManager();
                for (DocumentModel doc : commentManager.getComments(documentModel)) {
                    if (!"moderation_published".equals(doc.getCurrentLifeCycleState())) continue;
                    modificationDate = (GregorianCalendar)doc.getProperty("comment:creationDate").getValue();
                    simpleDateFormat = new SimpleDateFormat("dd MMMM", WebEngine.getActiveContext().getLocale());
                    creationDate = simpleDateFormat.format(modificationDate.getTime());
                    author = (String)((Object)doc.getProperty("comment:author").getValue());
                    commentText = (String)((Object)doc.getProperty("comment:text").getValue());
                    commentModel = new CommentModel(creationDate, author, commentText, doc.getRef().toString(), false);
                    model.addItem((Model)commentModel);
                }
                for (DocumentModel doc : commentManager.getComments(documentModel)) {
                    if (!"moderation_pending".equals(doc.getCurrentLifeCycleState())) continue;
                    modificationDate = (GregorianCalendar)doc.getProperty("comment:creationDate").getValue();
                    simpleDateFormat = new SimpleDateFormat("dd MMMM", WebEngine.getActiveContext().getLocale());
                    creationDate = simpleDateFormat.format(modificationDate.getTime());
                    author = (String)((Object)doc.getProperty("comment:author").getValue());
                    commentText = (String)((Object)doc.getProperty("comment:text").getValue());
                    commentModel = new CommentModel(creationDate, author, commentText, doc.getRef().toString(), true);
                    model.addItem((Model)commentModel);
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }
}

