/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.SearchListModel;
import org.nuxeo.webengine.sites.models.SearchModel;
import org.nuxeo.webengine.sites.utils.SiteQueriesColection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class SearchResultsFragment
extends AbstractFragment {
    private static final int nrWordsFromDescription = 50;

    public Model getModel() throws ModelException {
        SearchListModel model = new SearchListModel();
        try {
            if (WebEngine.getActiveContext() != null) {
                WebContext ctx = WebEngine.getActiveContext();
                CoreSession session = ctx.getCoreSession();
                DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
                String searchParam = (String)ctx.getProperty("searchParam");
                String tagDocumentId = (String)ctx.getProperty("tag_document");
                String documentType = (String)ctx.getProperty("searchParamDocType");
                String dateAfter = (String)ctx.getProperty("dateAfter");
                String dateBefore = (String)ctx.getProperty("dateBefore");
                TagService tagService = (TagService)Framework.getService(TagService.class);
                SearchModel searchModel = null;
                GregorianCalendar date = null;
                SimpleDateFormat simpleDateFormat = null;
                String created = null;
                String modified = null;
                String author = null;
                String path = null;
                String name = null;
                String description = null;
                DocumentModel ws = SiteUtils.getFirstWebSiteParent(session, documentModel);
                DocumentModelListImpl results = new DocumentModelListImpl(new ArrayList());
                if ((!StringUtils.isEmpty((String)searchParam) || dateAfter != null && dateBefore != null) && ws != null && StringUtils.isEmpty((String)tagDocumentId)) {
                    results = SiteQueriesColection.querySearchPages(session, searchParam, ws.getPathAsString(), documentType, dateAfter, dateBefore);
                }
                if (StringUtils.isEmpty((String)searchParam) && StringUtils.isNotEmpty((String)tagDocumentId)) {
                    List docsForTag = tagService.listDocumentsForTag(session, tagDocumentId, session.getPrincipal().getName());
                    for (String docForTagId : docsForTag) {
                        DocumentModel document = session.getDocument((DocumentRef)new IdRef(docForTagId));
                        DocumentModel webSite = SiteUtils.getFirstWebSiteParent(session, document);
                        if (!ws.equals(webSite)) continue;
                        results.add((Object)session.getDocument((DocumentRef)new IdRef(docForTagId)));
                    }
                }
                for (DocumentModel document : results) {
                    date = SiteUtils.getGregorianCalendar(document, "dc:created");
                    simpleDateFormat = new SimpleDateFormat("dd MMMM yyyy", WebEngine.getActiveContext().getLocale());
                    created = simpleDateFormat.format(date.getTime());
                    date = SiteUtils.getGregorianCalendar(document, "dc:modified");
                    modified = simpleDateFormat.format(date.getTime());
                    author = SiteUtils.getUserDetails(SiteUtils.getString(document, "dc:creator"));
                    path = SiteUtils.getPagePath(ws, document);
                    name = SiteUtils.getString(document, "dc:title");
                    description = SiteUtils.getFistNWordsFromString(SiteUtils.getString(document, "dc:description"), 50);
                    searchModel = new SearchModel(name, description, path, author, created, modified);
                    model.addItem((Model)searchModel);
                }
            }
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e);
        }
        return model;
    }
}

