/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.TagCloudListModel;
import org.nuxeo.webengine.sites.models.TagCloudModel;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class TagCloudFragment
extends AbstractFragment {
    public Model getModel() throws ModelException {
        TagCloudListModel model = new TagCloudListModel();
        try {
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (tagService != null && WebEngine.getActiveContext() != null && tagService.isEnabled()) {
                WebContext ctx = WebEngine.getActiveContext();
                CoreSession session = ctx.getCoreSession();
                DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
                DocumentModel siteDocument = SiteUtils.getFirstWebSiteParent(session, documentModel);
                TagCloudModel tagCloudModel = null;
                List tagCloud = tagService.getPopularCloud(session, siteDocument);
                if (tagCloud != null && !tagCloud.isEmpty()) {
                    for (WeightedTag weightedTag : tagCloud) {
                        tagCloudModel = new TagCloudModel(weightedTag.tagLabel, weightedTag.tagId, weightedTag.weight);
                        model.addItem((Model)tagCloudModel);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e);
        }
        return model;
    }
}

