/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.JsonAdapter;
import org.nuxeo.webengine.sites.models.WebpageListModel;
import org.nuxeo.webengine.sites.models.WebpageModel;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class AllWebpageFragment
extends AbstractFragment {
    public Model getModel() throws ModelException {
        WebpageListModel model = new WebpageListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            try {
                for (DocumentModel webPage : session.getChildren(documentModel.getRef(), "WebPage")) {
                    if (webPage.getCurrentLifeCycleState().equals("deleted")) continue;
                    String name = SiteUtils.getString(webPage, "dc:title");
                    String path = JsonAdapter.getRelativePath(documentModel, webPage).toString();
                    WebpageModel webpageModel = new WebpageModel(name, path);
                    model.addItem((Model)webpageModel);
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }
}

