/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.utils;

import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class SiteQueriesCollection {
    private SiteQueriesCollection() {
    }

    public static DocumentModelList querySitesByUrlAndDocType(CoreSession session, final String url, String documentType) throws ClientException {
        String queryString = String.format("SELECT * FROM %s WHERE ecm:mixinType = 'WebView' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' AND webc:isWebContainer = 1", documentType);
        return session.query(queryString, new Filter(){
            private static final long serialVersionUID = 259658360650139844L;

            public boolean accept(DocumentModel docModel) {
                try {
                    String webcUrl = (String)((Object)docModel.getPropertyValue("webc:url"));
                    if (webcUrl != null) {
                        String encodedUrl = URIUtils.quoteURIPathComponent((String)url, (boolean)false);
                        return webcUrl.equals(encodedUrl);
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
        });
    }

    public static boolean checkUnrestrictedSiteExistenceByUrlAndDocType(CoreSession session, String url, String documentType) throws ClientException {
        String queryString = String.format("SELECT * FROM %s WHERE ecm:mixinType = 'WebView' AND webc:url = \"%s\" AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' AND webc:isWebContainer = 1", documentType, url);
        UnrestrictedQueryRunner runner = new UnrestrictedQueryRunner(session, queryString);
        runner.runUnrestricted();
        return runner.getResultsSize() >= 1;
    }

    public static DocumentModelList queryAllSites(CoreSession session, String documentType) throws ClientException {
        String queryString = String.format("SELECT * FROM %s WHERE ecm:mixinType = 'WebView' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' AND webc:isWebContainer = 1", documentType);
        return session.query(queryString);
    }

    public static DocumentModelList queryLastModifiedPages(CoreSession session, String parent, String documentType, int numberLimit) throws ClientException {
        String queryString = String.format("SELECT * FROM %s WHERE ecm:path STARTSWITH '%s' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' ORDER BY dc:modified DESC", documentType, parent);
        return session.query(queryString, null, (long)numberLimit, 0L, true);
    }

    public static DocumentModelList queryLastComments(CoreSession session, String parent, int numberLimit, boolean isModerated) throws ClientException {
        String queryString = isModerated ? String.format("SELECT * FROM Document WHERE ecm:primaryType like 'Comment' AND ecm:path STARTSWITH '%s' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState = '%s' ORDER BY dc:modified DESC", parent, "moderation_published") : String.format("SELECT * FROM Document WHERE ecm:primaryType like 'Comment' AND ecm:path STARTSWITH '%s' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' ORDER BY dc:modified DESC", parent);
        return session.query(queryString, null, (long)numberLimit, 0L, true);
    }

    public static DocumentModelList querySearchPages(CoreSession session, String query, String parent, String documentType, String dateAfter, String dateBefore) throws ClientException {
        StringBuilder queryString = new StringBuilder(String.format("SELECT * FROM %s WHERE ecm:path STARTSWITH  '%s' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'", documentType, parent));
        if (query != null) {
            queryString.append(String.format(" AND ecm:fulltext LIKE '%s' ", query));
        }
        if (dateAfter != null && dateBefore != null) {
            queryString.append(String.format(" AND dc:created BETWEEN DATE '%s' AND DATE '%s' ", dateAfter, dateBefore));
        }
        return session.query(queryString.toString());
    }

    static class UnrestrictedQueryRunner
    extends UnrestrictedSessionRunner {
        DocumentModelList results;
        String queryString;

        public UnrestrictedQueryRunner(CoreSession session, String queryString) {
            super(session);
            this.queryString = queryString;
        }

        public void run() throws ClientException {
            this.results = this.session.query(this.queryString);
        }

        public int getResultsSize() {
            return this.results.size();
        }
    }
}

