/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.wiki.rendering;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.rendering.wiki.WikiFilter;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializer;
import org.nuxeo.ecm.platform.rendering.wiki.WikiTransformer;
import org.nuxeo.ecm.platform.rendering.wiki.extensions.PatternFilter;
import org.nuxeo.ecm.webengine.rendering.RenderingExtensionDescriptor;
import org.nuxeo.webengine.sites.wiki.rendering.WikiSitesFilterDescriptor;

@XObject(value="rendering-extension")
public class WikiSitesTransformerDescriptor
extends RenderingExtensionDescriptor {
    @XNode(value="@serializer")
    protected Class<?> serializerClass;
    @XNodeList(value="filter", type=ArrayList.class, componentType=WikiSitesFilterDescriptor.class)
    protected List<WikiSitesFilterDescriptor> filters;

    @XNode(value="@name")
    protected void setName(String name) {
        this.name = name;
    }

    @XNode(value="@class")
    protected void setClassName(Class<?> klass) {
        this.klass = klass;
    }

    public WikiTransformer newInstance() throws Exception {
        WikiTransformer tr = this.serializerClass == null ? new WikiTransformer() : new WikiTransformer((WikiSerializer)this.serializerClass.newInstance());
        WikiSerializer serializer = tr.getSerializer();
        for (WikiSitesFilterDescriptor wfd : this.filters) {
            if (wfd.clazz != null) {
                Class<?> clazz = Class.forName(wfd.clazz);
                WikiFilter filter = (WikiFilter)clazz.newInstance();
                serializer.addFilter(filter);
                continue;
            }
            serializer.addFilter((WikiFilter)new PatternFilter(wfd.pattern, wfd.replacement));
        }
        return tr;
    }
}

