/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree;

import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;
import org.nuxeo.ecm.webengine.ui.tree.TreeItemVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSonTreeSerializer
implements TreeItemVisitor {
    public String getUrl(TreeItem item) {
        return item.getPath().toString();
    }

    public JSONArray toJSON(Collection<TreeItem> items) {
        JSONArray ar = new JSONArray();
        for (TreeItem item : items) {
            ar.add((Object)this.toJSON(item));
        }
        return ar;
    }

    public JSONArray toJSON(TreeItem[] items) {
        JSONArray ar = new JSONArray();
        for (TreeItem item : items) {
            ar.add((Object)this.toJSON(item));
        }
        return ar;
    }

    public JSONObject toJSON(TreeItem root) {
        return (JSONObject)root.accept(this);
    }

    @Override
    public Object visit(TreeItem item) {
        TreeItem[] children;
        JSONArray jsons = null;
        if (item.isExpanded() && (children = item.getChildren()) != null && children.length > 0) {
            jsons = new JSONArray();
            for (TreeItem child : children) {
                JSONObject childJson = (JSONObject)this.visit(child);
                jsons.add((Object)childJson);
            }
        }
        return this.item2JSON(item, jsons);
    }

    protected JSONObject item2JSON(TreeItem item, JSONArray children) {
        JSONObject json = new JSONObject();
        json.element("text", (Object)item.getLabel()).element("id", (Object)item.getPath().toString()).element("href", (Object)this.getUrl(item));
        json.element("expanded", item.isExpanded());
        if (item.isContainer()) {
            if (item.isContainer()) {
                if (item.hasChildren()) {
                    json.element("children", (Collection)children);
                } else {
                    json.element("hasChildren", true);
                }
            } else {
                json.element("hasChildren", false);
            }
        }
        return json;
    }
}

