/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree;

import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;
import org.nuxeo.ecm.webengine.ui.tree.TreeItemImpl;
import org.nuxeo.ecm.webengine.ui.tree.TreeModel;

public class TreeModelImpl
implements TreeModel {
    private static final long serialVersionUID = 1L;
    protected ContentProvider provider;
    protected TreeItem root;

    public TreeModelImpl() {
    }

    public TreeModelImpl(ContentProvider provider) {
        this.provider = provider;
    }

    @Override
    public ContentProvider getContentProvider() {
        return this.provider;
    }

    @Override
    public void setContentProvider(ContentProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setInput(Object input) {
        this.root = input == null ? null : new TreeItemImpl(this.provider, input);
    }

    @Override
    public TreeItem getRoot() {
        return this.root;
    }

    @Override
    public TreeItem findAndReveal(String path) {
        return this.findAndReveal(new Path(path));
    }

    @Override
    public TreeItem find(String path) {
        return this.find(new Path(path));
    }

    @Override
    public TreeItem findAndReveal(Path path) {
        if (this.root == null) {
            return null;
        }
        return this.root.findAndReveal(path);
    }

    @Override
    public TreeItem find(Path path) {
        if (this.root == null) {
            return null;
        }
        Path rootPath = this.root.getPath();
        int p = path.matchingFirstSegments(rootPath);
        if (p == rootPath.segmentCount()) {
            return this.root.find(path.removeFirstSegments(p));
        }
        return null;
    }

    @Override
    public Object getInput() {
        return this.root == null ? null : this.root.getObject();
    }

    public boolean hasInput() {
        return this.root != null;
    }
}

