/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wiki.listener;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.util.RelationHelper;
import org.nuxeo.ecm.wiki.listener.WordExtractor;
import org.nuxeo.ecm.wiki.rendering.WikiPageLinkResolver;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.common.CommonWikiParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiHelper {
    public static final org.nuxeo.ecm.platform.relations.api.Resource HAS_LINK_TO = new ResourceImpl("http://www.nuxeo.org/wiki/hasLinkTo");
    public static final String WIKI_ROOT_PATH = "/default-domain/workspaces/wikis";

    public static List<String> getWordLinks(DocumentModel doc) {
        try {
            String content = (String)((Object)doc.getPart("wikiPage").get("content").getValue());
            StringBuffer collector = new StringBuffer();
            WordExtractor extractor = new WordExtractor(collector);
            CommonWikiParser parser = new CommonWikiParser();
            try {
                parser.parse((Reader)new StringReader(content), (IWemListener)extractor);
            }
            catch (WikiParserException e) {
                e.printStackTrace();
            }
            return WikiHelper.getWordLinks(collector.toString());
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void updateRelations(DocumentModel doc) {
        List<String> list = WikiHelper.getWordLinks(doc);
        ArrayList<StatementImpl> stmts = RelationHelper.getStatements((DocumentModel)doc, (org.nuxeo.ecm.platform.relations.api.Resource)HAS_LINK_TO);
        try {
            RelationManager rm = RelationHelper.getRelationManager();
            if (stmts != null) {
                rm.remove("default", (List)stmts);
                stmts.clear();
            } else {
                stmts = new ArrayList<StatementImpl>();
            }
            if (list != null) {
                QNameResource docResource = RelationHelper.getDocumentResource((DocumentModel)doc);
                for (String word : list) {
                    if (!word.startsWith(".")) {
                        word = WikiHelper.getAbsolutePageLink(doc, word);
                    }
                    StatementImpl stmt = new StatementImpl((Node)docResource, (Node)HAS_LINK_TO, (Node)new LiteralImpl(word));
                    stmts.add(stmt);
                }
                rm.add("default", stmts);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getWordLinks(String text) {
        ArrayList<String> wordLinks = new ArrayList<String>();
        Matcher matcher = WikiPageLinkResolver.PAGE_LINK_PATTERN.matcher(text);
        while (matcher.find()) {
            String s = matcher.group(0);
            if (wordLinks.contains(s)) continue;
            wordLinks.add(s);
        }
        return wordLinks;
    }

    public static String getAbsolutePageLink(DocumentModel doc, String relativeLink) {
        if (relativeLink.startsWith(".")) {
            return relativeLink;
        }
        Path path = doc.getPath().removeFirstSegments(3);
        path = path.removeLastSegments(1);
        return "." + path.toString().replace("/", ".") + "." + relativeLink;
    }

    public static List<Map<String, String>> getLinks(WebContext ctx) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        DocumentModel doc = null;
        Resource resource = ctx.getTargetObject();
        if (resource instanceof DocumentObject) {
            DocumentObject docObj = (DocumentObject)resource;
            doc = docObj.getDocument();
        }
        if (doc == null) {
            return list;
        }
        DocumentModelList l = RelationHelper.getSubjectDocuments((org.nuxeo.ecm.platform.relations.api.Resource)HAS_LINK_TO, (String)WikiHelper.getPageAbsoluteLink(doc), (String)doc.getSessionId());
        String prefix = ctx.getModulePath();
        for (DocumentModel d : l) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                map.put("title", d.getTitle());
                map.put("href", prefix + "/" + d.getPath().removeFirstSegments(3).toString());
                list.add(map);
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static String getPageAbsoluteLink(DocumentModel doc) {
        String s = doc.getPath().removeFirstSegments(3).toString();
        return "." + s.replace("/", ".");
    }
}

