/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wiki.relation;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.webengine.util.RelationHelper;
import org.nuxeo.ecm.wiki.listener.WikiHelper;
import org.nuxeo.ecm.wiki.relation.WikiRelationConstants;

public class WikiRelationHelper
implements WikiRelationConstants {
    private WikiRelationHelper() {
    }

    public static void updateRelations(DocumentModel doc) {
        List<String> list = WikiHelper.getWordLinks(doc);
        ArrayList<StatementImpl> stmts = RelationHelper.getStatements((DocumentModel)doc, (Resource)HAS_LINK_TO);
        try {
            RelationManager rm = RelationHelper.getRelationManager();
            if (stmts != null) {
                rm.remove("default", (List)stmts);
                stmts.clear();
            } else {
                stmts = new ArrayList<StatementImpl>();
            }
            if (list != null) {
                QNameResource docResource = RelationHelper.getDocumentResource((DocumentModel)doc);
                for (String word : list) {
                    StatementImpl stmt = new StatementImpl((Node)docResource, (Node)HAS_LINK_TO, (Node)new LiteralImpl(word));
                    stmts.add(stmt);
                }
                rm.add("default", stmts);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }
}

