/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wiki.rendering;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.rendering.wiki.WikiFilter;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;

public class WikiPageLinkResolver
implements WikiFilter {
    private static final String LINK_CLASS_EXIST = "exist";
    private static final String LINK_CLASS_DONTEXISTS = "dontexists";
    public static final String PATTERN = "(\\.)?([A-Z]+[a-z]+[A-Z][A-Za-z]*\\.)*([A-Z]+[a-z]+[A-Z][A-Za-z]*)";
    public static final Pattern PAGE_LINK_PATTERN = Pattern.compile("(\\.)?([A-Z]+[a-z]+[A-Z][A-Za-z]*\\.)*([A-Z]+[a-z]+[A-Z][A-Za-z]*)");
    static final String LINK_TEMPLATE = "<a  href=\"%s\" class=\"%s\">%s</a>";

    public String apply(String content) {
        Matcher m = PAGE_LINK_PATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        if (!m.find()) {
            return content;
        }
        do {
            String s = m.group();
            String link = this.builsLinks(s);
            m.appendReplacement(sb, link);
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    protected String builsLinks(String pageName) {
        DocumentModel doc = null;
        String basePath = null;
        WebContext ctx = WebEngine.getActiveContext();
        Resource resource = ctx.getTargetObject();
        StringBuffer links = new StringBuffer();
        StringBuffer relativePath = new StringBuffer();
        if (pageName.startsWith(".")) {
            basePath = ctx.getModulePath();
            String[] segments = pageName.substring(1).split("\\.");
            doc = this.getWikisRoot();
            for (String s : segments) {
                links.append(".");
                relativePath.append("/").append(s);
                if (doc != null) {
                    doc = this.getDocument(doc, s);
                }
                links.append(this.buildLink(basePath, relativePath, s, doc));
            }
        } else {
            String[] segments;
            basePath = resource.getPrevious().getPath();
            doc = this.getResourceDocument(resource.getPrevious());
            for (String s : segments = pageName.split("\\.")) {
                relativePath.append("/").append(s);
                if (doc != null) {
                    doc = this.getDocument(doc, s);
                }
                links.append(this.buildLink(basePath, relativePath, s, doc));
                links.append(".");
            }
            links.deleteCharAt(links.length() - 1);
        }
        return links.toString();
    }

    protected String buildLink(String basePath, StringBuffer relativePath, String s, DocumentModel doc) {
        String linkClass = null;
        linkClass = doc == null ? LINK_CLASS_DONTEXISTS : LINK_CLASS_EXIST;
        return String.format(LINK_TEMPLATE, basePath + relativePath, linkClass, s);
    }

    protected DocumentModel getWikisRoot() {
        WebContext ctx = WebEngine.getActiveContext();
        CoreSession session = ctx.getCoreSession();
        PathRef ref = new PathRef("/default-domain/workspaces/wikis");
        try {
            return session.getDocument((DocumentRef)ref);
        }
        catch (ClientException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DocumentModel getResourceDocument(Resource resource) {
        if (resource instanceof DocumentObject) {
            DocumentObject docObj = (DocumentObject)resource;
            return docObj.getDocument();
        }
        return null;
    }

    private DocumentModel getDocument(DocumentModel doc, String segment) {
        WebContext ctx = WebEngine.getActiveContext();
        CoreSession session = ctx.getCoreSession();
        Path p = doc.getPath().append(segment);
        PathRef ref = new PathRef(p.toString());
        try {
            if (session.exists((DocumentRef)ref)) {
                return session.getDocument((DocumentRef)ref);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return null;
    }
}

