/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.rest.DocumentFactory;
import org.nuxeo.ecm.core.rest.DocumentHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@WebObject(type="wikis", facets={"mainWiki"})
@Produces(value={"text/html; charset=UTF-8"})
public class Main
extends ModuleRoot {
    DocumentModel doc;

    public DocumentModel getDocument() {
        if (this.doc == null) {
            this.doc = Main.getRootDocument();
        }
        return this.doc;
    }

    public static DocumentModel getRootDocument() {
        try {
            PathRef wikisPath = new PathRef("/default-domain/workspaces/wikis");
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            if (!session.exists((DocumentRef)wikisPath)) {
                DocumentModel newDoc = session.createDocumentModel("/default-domain/workspaces/", "wikis", "Workspace");
                if (newDoc.getTitle().length() == 0) {
                    newDoc.getPart("dublincore").get("title").setValue((Object)newDoc.getName());
                }
                newDoc = session.createDocument(newDoc);
                session.save();
                return newDoc;
            }
            return WebEngine.getActiveContext().getCoreSession().getDocument((DocumentRef)wikisPath);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    public Response doPost() {
        String name = this.ctx.getForm().getString("name");
        DocumentModel newDoc = DocumentHelper.createDocument((WebContext)this.ctx, (DocumentModel)this.getDocument(), (String)name);
        return this.redirect(this.getPath() + '/' + newDoc.getName());
    }

    @GET
    public Object doGet() throws ClientException {
        DocumentModelList docs = this.ctx.getCoreSession().getChildren(this.getDocument().getRef(), "Wiki");
        return this.getView("index").arg("wikis", (Object)docs);
    }

    @javax.ws.rs.Path(value="{segment}")
    public Object getWiki(@PathParam(value="segment") String segment) {
        return DocumentFactory.newDocument((WebContext)this.ctx, (String)this.getDocument().getPath().append(segment).toString());
    }

    @GET
    @javax.ws.rs.Path(value="create/{segment}")
    public Response createPage(@PathParam(value="segment") String segment) {
        try {
            CoreSession session = this.ctx.getCoreSession();
            DocumentModel newDoc = session.createDocumentModel("/default-domain/workspaces/", segment, "Workspace");
            if (newDoc.getTitle().length() == 0) {
                newDoc.getPart("dublincore").get("title").setValue((Object)newDoc.getName());
            }
            newDoc = session.createDocument(newDoc);
            session.save();
            return this.redirect(this.path + "/" + segment);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error/error_401.ftl")).build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).build();
        }
        return super.handleError(e);
    }

    public String getLink(DocumentModel doc) {
        this.getDocument();
        String type = doc.getType();
        if ("Wiki".equals(type)) {
            return this.getPath() + "/" + doc.getName();
        }
        if ("WikiPage".equals(type)) {
            Path path = doc.getPath();
            int cnt = path.segmentCount();
            String s = this.getPath() + "/" + path.segment(cnt - 2) + "/" + path.lastSegment();
            return s;
        }
        return super.getLink(doc);
    }
}

