/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditStorage;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.ecm.automation.features"}), @Deploy(value={"org.nuxeo.runtime.metrics"}), @Deploy(value={"org.nuxeo.ecm.platform.audit.api"}), @Deploy(value={"org.nuxeo.runtime.datasource"}), @Deploy(value={"org.nuxeo.ecm.core.persistence"}), @Deploy(value={"org.nuxeo.ecm.platform.audit"}), @Deploy(value={"org.nuxeo.ecm.platform.uidgen.core"}), @Deploy(value={"org.nuxeo.elasticsearch.core.test:elasticsearch-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:audit-jpa-storage-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:nxaudit-ds.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:nxuidsequencer-ds.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})})
public class TestAuditMigration {
    public static final String DEFAULT_AUDIT_STORAGE = "defaultAuditStorage";
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected TransactionalFeature txFeature;
    @Inject
    protected AutomationService automationService;
    protected DefaultAuditBackend jpaBackend;

    @Before
    public void setupIndex() throws Exception {
        LogEntryGen.flushAndSync();
        this.esa.initIndexes(true);
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        Assert.assertNotNull((Object)audit);
        this.jpaBackend = (DefaultAuditBackend)audit.getAuditStorage(DEFAULT_AUDIT_STORAGE);
    }

    @After
    public void tearDown() {
        this.jpaBackend.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), em -> {
            em.createNativeQuery("delete from nxp_logs_mapextinfos").executeUpdate();
            em.createNativeQuery("delete from nxp_logs_extinfo").executeUpdate();
            em.createNativeQuery("delete from nxp_logs").executeUpdate();
        });
    }

    @Test
    public void shouldMigrate() throws Exception {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int i = 0; i < 1000; ++i) {
            LogEntry entry = LogEntryGen.doCreateEntry("mydoc", "evt" + i, "cat" + i % 2);
            HashMap<String, ExtendedInfoImpl.StringInfo> extendedInfos = new HashMap<String, ExtendedInfoImpl.StringInfo>();
            extendedInfos.put("json", new ExtendedInfoImpl.StringInfo("{\"k1\":\"test\", \"k2\":\"test\", \"k3\":{\"k4\":\"test\", \"k5\":\"test\"}}"));
            extendedInfos.put("json2", new ExtendedInfoImpl.StringInfo("[{t1=test1:toto, t2=test1},{t1=test2, t2=test2}]"));
            entry.setExtendedInfos(extendedInfos);
            entries.add(entry);
        }
        this.jpaBackend.addLogEntries(entries);
        this.txFeature.nextTransaction();
        List res = this.jpaBackend.nativeQuery("select count(*) from LogEntry", 1, 20);
        long nbEntriesToMigrate = (Long)res.get(0);
        Assert.assertEquals((long)1000L, (long)nbEntriesToMigrate);
        AuditBackend backend = (AuditBackend)Framework.getService(AuditBackend.class);
        Assert.assertNotNull((Object)backend);
        Assert.assertTrue((boolean)(backend instanceof ESAuditBackend));
        ESAuditBackend esBackend = (ESAuditBackend)backend;
        esBackend.migrate(100);
        ((WorkManager)Framework.getService(WorkManager.class)).awaitCompletion(1L, TimeUnit.MINUTES);
        LogEntryGen.flushAndSync();
        String singleQuery = "            {\"query\": {\n                \"bool\" : {\n                  \"must\" : {\n                    \"match\" : {\n                      \"docUUID\" : {\n                        \"query\" : \"mydoc\"\n                      }\n                    }\n                  }\n                }\n              }}          \n";
        List migratedEntries = backend.nativeQuery(singleQuery, 0, 1001);
        Assert.assertEquals((long)1000L, (long)migratedEntries.size());
    }

    @Test
    @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-override-contrib.xml"})
    public void shouldMigrateWithPreviousMapping() throws Exception {
        this.shouldMigrate();
    }

    @Test
    public void testRestorationFromAuditStorage() throws Exception {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int i = 0; i < 1000; ++i) {
            entries.add(LogEntryGen.doCreateEntry("mydoc", "evt", "cat"));
        }
        this.jpaBackend.addLogEntries(entries);
        List originalEntries = this.jpaBackend.queryLogs((QueryBuilder)new AuditQueryBuilder());
        Assert.assertEquals((long)1000L, (long)originalEntries.size());
        this.txFeature.nextTransaction();
        ESAuditBackend esBackend = (ESAuditBackend)Framework.getService(AuditBackend.class);
        esBackend.restore((AuditStorage)this.jpaBackend, 100, 10);
        LogEntryGen.flushAndSync();
        List migratedEntries = esBackend.queryLogs((QueryBuilder)new AuditQueryBuilder());
        Assert.assertEquals((long)1000L, (long)migratedEntries.size());
    }

    @Test
    public void testRestorationFromAutomationOperation() throws Exception {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int i = 0; i < 1000; ++i) {
            entries.add(LogEntryGen.doCreateEntry("mydoc", "evt", "cat"));
        }
        this.jpaBackend.addLogEntries(entries);
        this.txFeature.nextTransaction();
        OperationContext ctx = new OperationContext(this.session);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("auditStorage", DEFAULT_AUDIT_STORAGE);
        this.automationService.run(ctx, "Audit.Restore", params);
        LogEntryGen.flushAndSync();
        ESAuditBackend esBackend = (ESAuditBackend)Framework.getService(AuditBackend.class);
        List migratedEntries = esBackend.queryLogs((QueryBuilder)new AuditQueryBuilder());
        Assert.assertEquals((long)1000L, (long)migratedEntries.size());
    }
}

